/*
 *  Remote Network application system for DNAS -- GTK+ image loading test routine
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: test-loadimage.c,v 1.1 2002/09/27 11:41:57 dancer Exp $
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <locale.h>
#include <dlfcn.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "rnas-monitor-gtk.h"

GdkPixmap* g_pixmap;		/* the main screen image. 
				   can be used as GdkDrawable
				 */
GdkGC * g_gc;			/* Drawing context */
GdkPixmap* my_icon;		/* current icon */
GdkBitmap* my_icon_shape;		/* current icon shape */
#define PIX_HEIGHT 128
#define PIX_WIDTH 128
#define DRAW_AREA_HEIGHT 128
#define DRAW_AREA_WIDTH 128

static gint window_destroy(GtkWidget *widget,GdkEvent *event,gpointer data)
{
  return(FALSE);
}

static void window_delete(GtkWidget *widget,gpointer data)
{
  gtk_main_quit();
}

gint expose_event(GtkWidget *widget,GdkEventExpose *event)
{
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
                  g_pixmap,
                  0,0,
                  0,0,
                  DRAW_AREA_WIDTH,DRAW_AREA_HEIGHT);
  return FALSE;
}

void
draw_event(GdkDrawable*gd)
{
  int x =2, y=3;
  
  gdk_draw_rectangle(gd,g_gc,TRUE,0,0,PIX_WIDTH,PIX_HEIGHT);
  
  gdk_gc_set_clip_mask(g_gc,my_icon_shape);
  gdk_gc_set_clip_origin(g_gc,x,y);
  gdk_draw_pixmap(gd,
		  g_gc,
		  my_icon,
		  0,0,x,y,
		  32,32);
}



int
main(int argc, char *argv[])
{
  GtkWidget *window;
  GtkWidget *drawing_area;
  GdkPixmap*pixmap;

  gtk_init(&argc,&argv);

  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window),FALSE,FALSE,FALSE);
  gtk_widget_show(window);
  gtk_signal_connect(GTK_OBJECT(window),"delete_event",
                     GTK_SIGNAL_FUNC(window_delete),NULL);
  gtk_signal_connect(GTK_OBJECT(window),"destroy",
                     GTK_SIGNAL_FUNC(window_destroy),NULL);
  
  drawing_area=gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawing_area),
                        DRAW_AREA_WIDTH,DRAW_AREA_HEIGHT);
  g_pixmap=gdk_pixmap_new(window->window,PIX_WIDTH,PIX_HEIGHT,-1);

  gtk_signal_connect(GTK_OBJECT(drawing_area),"expose_event",
                     (GtkSignalFunc)expose_event,NULL);
  

  gtk_widget_set_events(drawing_area,GDK_EXPOSURE_MASK
                        | GDK_BUTTON_PRESS_MASK
                        | GDK_POINTER_MOTION_MASK
                        | GDK_KEY_PRESS_MASK);


  gtk_container_add(GTK_CONTAINER(window),drawing_area);
  gtk_widget_show(drawing_area);
  g_gc=gdk_gc_new(window->window);
  my_icon = pixmap =gdk_pixmap_create_from_xpm(window->window,
					       &my_icon_shape,
					       NULL,
					       PKGDATADIR "/redball.xpm");
  if (!pixmap)
    {
      printf("error\n");
      exit (1);
    }

  draw_event (g_pixmap);
  
  
  gtk_main();
  return (0);
}
