/* BTP library - Banana Tree Protocol
 * Copyright (C) 1999-2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */


/**

   b_conn_io handles reads and writing IOChannels and IOChannel errors
   and hups.

 */


#ifndef _B_CONN_IO_H
#define _B_CONN_IO_H

#include "b_conn.h"

gboolean b_conn_watch_update (BConn* conn, guint new_flags);

#define b_conn_watch_read(C) \
  do{ b_conn_watch_update (C, (C)->watch_flags | G_IO_IN); } while(0);
#define b_conn_watch_write(C) \
  do{ b_conn_watch_update (C, (C)->watch_flags | G_IO_OUT); } while(0);
#define b_conn_watch_error(C) \
  do{ b_conn_watch_update (C, (C)->watch_flags | G_IO_ERR | G_IO_HUP | G_IO_NVAL); } while(0);

#define b_conn_ignore_read(C) \
  do{ b_conn_watch_update (C, (C)->watch_flags & ~G_IO_IN); } while(0);
#define b_conn_ignore_write(C) \
  do{ b_conn_watch_update (C, (C)->watch_flags & ~G_IO_OUT); } while(0);
#define b_conn_ignore_error(C) \
  do{ b_conn_watch_update (C, (C)->watch_flags & ~(G_IO_ERR | G_IO_HUP | G_IO_NVAL)); } while(0);
#define b_conn_ignore_all(C) \
  do{ b_conn_watch_update (C, 0); } while(0);

#define b_conn_watching_read(C)	 (((C)->watch_flags & G_IO_IN ) != 0)
#define b_conn_watching_write(C) (((C)->watch_flags & G_IO_OUT) != 0)
#define b_conn_watching_err(C)	 (((C)->watch_flags & G_IO_ERR) != 0)
#define b_conn_watching_any(C)	 (((C)->watch_flags           ) != 0)


#endif /* _B_CONN_IO_H */
