/*
 *  preferences.c 
 *
 *  Copyright (c) 2005 Giansalvo Gusinu <giansalvo at gusinu.net>
 *  Copyright (C) 1999 Cory Lueninghoener (cluenin1@bigred.unl.edu)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <pthread.h>
#include <linux/types.h> 
#include <gtk/gtk.h>
#include <glib.h>
#include <linux/videodev.h>
#include <png.h>

#include "gqcam.h"
#include "frontend.h"
#include "preferences.h"
#include "save.h"
#include "color.h"
#include "greyscale.h"
#include "timer.h"

void pref_dialog(GtkWidget *widget, struct Camera *camera)
{

  /* TODO improve GUI layout */

  /*
  GtkWidget *prefdialog;
  GtkWidget *prefnotebook;

  GtkWidget *generalpage;
  GtkWidget *generaltab;
  GtkWidget *autobright;

  GtkWidget *filterspage;
  GtkWidget *filterstab;
  GtkWidget *rgbswap;
	     force_YUV
	     force_RGB
	     force_JPEG

  GtkWidget *button;
  GtkWidget *label;
  */

  camera->pref_dialog.prefdialog = gtk_dialog_new();

  camera->pref_dialog.prefnotebook = gtk_notebook_new();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(camera->pref_dialog.prefdialog)->vbox),
                       camera->pref_dialog.prefnotebook, TRUE, TRUE, 0);
  gtk_widget_show(camera->pref_dialog.prefnotebook);


  /****************************/
  /* Tab General              */
  /****************************/
  camera->pref_dialog.generalpage = gtk_hbox_new(TRUE, 0);
  gtk_widget_show(camera->pref_dialog.generalpage);  
  camera->pref_dialog.generaltab = gtk_label_new("General");
  gtk_widget_show(camera->pref_dialog.generaltab);

  /* Auto brightness setting */
  camera->pref_dialog.autobright = gtk_check_button_new_with_label ("Autoscale brightness");
  gtk_box_pack_start(GTK_BOX(camera->pref_dialog.generalpage), camera->pref_dialog.autobright, TRUE, TRUE, 0);
  if(camera->autobright)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(camera->pref_dialog.autobright), 1);
  gtk_widget_show(camera->pref_dialog.autobright);

  /* append page */
  gtk_notebook_append_page(GTK_NOTEBOOK(camera->pref_dialog.prefnotebook),
                           camera->pref_dialog.generalpage, camera->pref_dialog.generaltab);

  /****************************/
  /* Tab Filters              */
  /****************************/
  camera->pref_dialog.filterspage = gtk_hbox_new(TRUE, 0);
  gtk_widget_show(camera->pref_dialog.filterspage);

  /* Filters */
  camera->pref_dialog.filterstab = gtk_label_new("Filters");
  gtk_widget_show(camera->pref_dialog.filterstab);

  /* RGB to BGR setting */
  camera->pref_dialog.rgbswap = gtk_check_button_new_with_label ("RGB -> BGR Conversion"); 
  gtk_box_pack_start(GTK_BOX(camera->pref_dialog.filterspage),
                     camera->pref_dialog.rgbswap, TRUE, TRUE, 0);
  if(camera->swapcolors)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(camera->pref_dialog.rgbswap), 1);
  gtk_widget_show(camera->pref_dialog.rgbswap);

  /*********************************************************/
  /* radio box with three radio buttons YUV, RGB, JPEG     */
  /*********************************************************/
  GtkWidget *tmp; /* temp pointers to build widgets */

  /* YUV */
  tmp = gtk_radio_button_new_with_label (NULL, "YUV");
  gtk_box_pack_start(GTK_BOX(camera->pref_dialog.filterspage), tmp, TRUE, TRUE, 0);
  if (camera->inputtype == INPUT_YUV)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tmp), TRUE);
  gtk_widget_show(tmp);
  camera->pref_dialog.force_YUV = tmp;

  /* RGB */
  tmp = gtk_radio_button_new_with_label(
	gtk_radio_button_group(GTK_RADIO_BUTTON(camera->pref_dialog.force_YUV)), "RGB");
  gtk_box_pack_start(GTK_BOX(camera->pref_dialog.filterspage), tmp, TRUE, TRUE, 0);
  if (camera->inputtype == INPUT_RGB)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (tmp), TRUE);
  gtk_widget_show(tmp);
  camera->pref_dialog.force_RGB = tmp;

  /* JPEG */
  tmp = gtk_radio_button_new_with_label(
	  gtk_radio_button_group(GTK_RADIO_BUTTON(camera->pref_dialog.force_YUV)), "JPEG");
  gtk_box_pack_start(GTK_BOX(camera->pref_dialog.filterspage), tmp, TRUE, TRUE, 0);
  if (camera->inputtype == INPUT_JPEG)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (tmp), TRUE);
  gtk_widget_show(tmp);
  camera->pref_dialog.force_JPEG = tmp;

  /* append page */
  gtk_notebook_append_page(GTK_NOTEBOOK(camera->pref_dialog.prefnotebook),
                           camera->pref_dialog.filterspage, camera->pref_dialog.filterstab);

  /****************************/
  /* OK - Apply - Close       */
  /****************************/
  /* Ok */
  camera->pref_dialog.button = gtk_button_new_with_label("Ok");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(camera->pref_dialog.prefdialog)->action_area), 
		      camera->pref_dialog.button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(camera->pref_dialog.button), "clicked", 
		      (GtkSignalFunc)ok_prefs, camera);
  gtk_widget_show (camera->pref_dialog.button);
  /* Apply */
  camera->pref_dialog.button = gtk_button_new_with_label("Apply");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(camera->pref_dialog.prefdialog)->action_area),
		      camera->pref_dialog.button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(camera->pref_dialog.button), "clicked", 
		      (GtkSignalFunc)apply_prefs, camera);
  gtk_widget_show (camera->pref_dialog.button);
  /* Close */
  camera->pref_dialog.button = gtk_button_new_with_label("Close");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(camera->pref_dialog.prefdialog)->action_area), 
		      camera->pref_dialog.button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(camera->pref_dialog.button), "clicked", 
		      (GtkSignalFunc)closedialog, camera->pref_dialog.prefdialog);
  gtk_widget_show (camera->pref_dialog.button);

  gtk_widget_show(camera->pref_dialog.prefdialog);

  return;
}

void read_pref_file(FILE *input, struct Camera *camera)
{
  char buff[1024], command[1024];  
  int val=0;
  
  while(fgets(buff, sizeof(buff), input) != NULL){
    if((buff[0] != '#') && (buff[0] != '\n'))
      {
	sscanf(buff, " %s %d", command, &val);
	//printf("%s: %d\n", command, val);
	if(!strcmp(command, "autobrightness"))
	  camera->autobright = val;
	else if(!strcmp(command, "swaprgb"))
	  camera->swapcolors = val;
	else if(!strcmp(command, "inputtype"))
	  camera->inputtype = val;	
	else
	  printf("Unknown preference: %s\n", command);
	
      }
  }
}

void save_pref_file(FILE *output, struct Camera *camera)
{
  fprintf(output, "autobrightness %d\n", camera->autobright);
  fprintf(output, "swaprgb %d\n", camera->swapcolors);
  fprintf(output, "inputtype %d\n", camera->inputtype);
}

void ok_prefs(GtkWidget *widget, struct Camera *camera)
{
  apply_prefs(widget, camera);
  closedialog(widget, camera->pref_dialog.prefdialog);
}


void apply_prefs(GtkWidget *widget, struct Camera *camera)
{
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(camera->pref_dialog.rgbswap)))
    camera->swapcolors = 1;
  else
    camera->swapcolors = 0;
  
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(camera->pref_dialog.autobright)))
    camera->autobright = 1;
  else
    camera->autobright = 0;
    
   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(camera->pref_dialog.force_YUV)))
    camera->inputtype = INPUT_YUV;
   else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(camera->pref_dialog.force_RGB)))
    camera->inputtype = INPUT_RGB;
   else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(camera->pref_dialog.force_JPEG)))
    camera->inputtype = INPUT_JPEG;
}
