//
// $Id: cmdline.h,v 1.1 2001/12/16 19:58:17 nfx3 Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/cmdline.h,v $
// $Revision: 1.1 $
// $Date: 2001/12/16 19:58:17 $
// $State: Exp $
//
// Cmdline: a class for parsing commandline arguments
// Author:  Niklas Fondberg<nfx3@sourceforge.net>
// Note:    Modified code auto created by 
//          genparse v0.5.1 (http://genparse.sourceforge.net)
//

#ifndef CMDLINE_H
#define CMDLINE_H

#include <iostream>
#include "String.h"

class Cmdline
{
private:
  /* parameters */
  int _s;
  string _o;
  bool _t;
  bool _C;
  string _c;
  bool _h;
  bool _v;

  /* other stuff to keep track of */
  string _executable;
  int _optind;
  int _argc;

public:
  /* constructor and destructor */
  Cmdline(int, char **) throw(string);
  ~Cmdline(){}

  /* usage function */
  void usage();

  /* return next (non-option) parameter */
  int next_param() { return _optind++; }
  bool has_more_params() { return _optind < _argc; }

  /* callback functions */

  int s() { return _s; }
  string o() { return _o; }
  bool t() { return _t; }
  bool C() { return _C; }
  string c() { return _c; }
  bool h() { return _h; }
  bool v() { return _v; }
};

#endif
