
//
// $Id: config.h,v 1.8 2003/03/03 23:18:48 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/config.h,v $
// $Revision: 1.8 $
// $Date: 2003/03/03 23:18:48 $
// $State: Exp $
//
// Author: Geoff Wong
//
// Note: configuration stuff should be encapsulated in a class
//       some day.
//
#ifndef _CONFIG_H
#define _CONFIG_H
#include <stdlib.h>
#include "String.h"
#include "distribution.h"
#include "hrtime.h"
#include <list>

/* constants */
#define SCENARIOS "/etc/hammerhead/scenarios/"
#define CONF_FILENAME "/etc/hammerhead/hh.conf"
#define HH_LOG "/var/tmp/hh.log"
#define REPORT_LOG "/var/tmp/report.log"
#define SESSIONS 100
#define HAMMER_PORT 80
#define SSL_PORT 443
#define SEED 0
#define SEQUENCEP 75
#define SLEEP 0
#define STARTLAG 1000
#define RUNTIME 0
#define REPORTTIME 0
#define MAXFAILURES 0

#define SO_SCN 1 /* select on scenarios */
#define SO_SEQ 2 /* select on sequence */
#define SELECT_ON SO_SCN

#ifdef SOLARIS
#ifndef INADDR_NONE
#define INADDR_NONE ((in_addr_t) -1)
#endif
#endif

extern char *SO_Names[];

extern int DNSTTLExpired;
extern int DNSTimeToLive;
extern int UseSSLLayer;

extern int SelectOn;


/* log file time format */
#define TF_NUMERIC  0
#define TF_STRING   1
extern int LogTimeFormat; 

extern list<String> ScenarioFiles;
	// a list of specific scenarios files to pull in 
    
extern list<String> ScenarioDirectories;
	// a list of directories to search 
    
extern String ConfName;
    // configuration file name
    
extern String HammerLog;
    // log file name
    
extern String ReportLog;
    // report log file name
    
extern String HTTPReqType;
    // HTTP request type (0.9,1.0,1.1 etc)
    
extern list<HammerTarget> HammerTargets;
	// list of possible targets to hammer. RoundRobin through the list.

extern list<BottleNeck> BottleNecks;
	// list of bottlenecks for client simulation.

extern list<String> IpAliasPattern;
extern list<long> IpAliases;
    // List of possible IpAliases to try with each session (thread).
    
extern String RobotId;
    // string for the identity of the user agent (if I am one)
    
extern int Sessions;
    // number of threads to run simultaneously
    
extern int Seed;
    // random number seed
    
extern int SequenceProbability;
    // chance of following a defined scenario sequence
    
extern int SleepTime;
    // no of nanoseconds to sleep between requests
    
extern int StartLag;
	// no of microseconds to sleep the sessions on startup.
    
extern int RunTime;
    // no of seconds to execute for
    
extern int CookieOn;
    // on/off - send a cookie to the client?
    
extern int PrematureClose;
    // chance of closing prematurely
    
extern int BadRequest;
    // chance of making a bad request
    
extern int ReportTime;
    // time between reports
    
extern int MaxFailures;
	// the maxium number of failures the we will tolerate before 
    // abondoning a test

extern int ThinkLimit;

extern int SummaryInterval;

extern int LoadImages;

extern int DoCrawl;
    // crawl through web pages (loading all links embedded in a page)

extern String CrawlRE;

// log level defines
#define CRAWL_CALLS	1
#define CRAWL_FOUND	2
#define CRAWL_SOURCE	4
#define CRAWL_IGNORED	8
#define CRAWL_REQUEST	16
#define CRAWL_NON_200	32
extern int LogLevel;

extern int OpenConfiguration();

extern int Shutdown; 
    // shutting down? declared in hammerhead.cc 
    
extern hrtime_t StartedTime;
    // the time we actually started the parent.

#endif 


