/* -*- C++ -*- */

// 


/*
 We need:

 chunks need to be able to go up to a 'staging' area
 that is also a slot heap: free & malloc in chunks.

 TopSlotHeap --
 free (Chunk) -- adds a chunk to the heap (NOT NECESSARILY EMPTY).
 malloc (Chunk) -- gets a chunk from the heap.



 LooseSlotHeap --
 free (Slot) -- returns a slot to its chunk.
 may move a chunk to its superheap.
 malloc (Slot) -- gets a slot (may get a chunk from super heap).

*/



class Foo : public ThreadHeap<16, LooseSlotHeap<8192, 32, 4, mallocHeap>, mallocHeap> {};

class ProcessHeap : public LooseSlotHeap<8192, 32, 4, mallocHeap> {};

class HoardHeap : public ThreadHeap<N, LooseSlotHeap<8192, 32, 4, ProcessHeap>, ProcessHeap> {};





size_t sizeTable[] = {8UL, 16UL, 24UL, 32UL, 40UL, 48UL, 56UL, 72UL, 80UL, 96UL, 120UL, 144UL, 168UL, 200UL, 240UL, 288UL, 344UL, 416UL, 496UL, 592UL, 712UL, 856UL, 1024UL, 1232UL, 1472UL, 1768UL, 2120UL, 2544UL, 3048UL, 3664UL, (8192UL - sizeof(Chunk))/2};

template <class Super>
class PageSegHeap : public SegHeap<sizeTable, sizeof(sizeTable)/sizeof(size_t), funkyFunc, SlotHeap<8192, Super>, Super>{};

// Each thread has its own HoardThreadHeap.
template <class Super>
class HoardThreadHeap : public PageSegHeap<PrefetchHeap<Super> >{};

template <class Super>
class LockedHoardThreadHeap : public LockedHeap<HoardThreadHeap<Super> >{};

template <class Super>
class HoardGlobalHeap : public HoardThreadHeap {};

// A Hoard heap has per-thread heaps which use per-processor heaps which rely on mmap.
template <class Super>
class HoardHeap : public PerThread<HoardThreadHeap<Super>, PerProcessor<HoardThreadHeap<Super>, HoardThreadHeap<Super> >{};


template <class ThreadHeaps<GlobalHeap>, class GlobalHeap>
class PerThread {

  inline void * malloc (size_t sz) {
    return myThreadHeap()->malloc(sz);
  }

  void free (void * ptr) {
    myThreadHeap()->free (ptr);
  }
};

