// xgen.c
// ------
//
// Every node sends a message to every node. 
// Queue them all up at time 0 and let them fight.

#include "node.h"
#include "measure.h"
#include "message.h"
extern measureclass measure;
extern int message_length;
extern int cube_size;

void xgen()
{
	for( int n1 = 0; n1 < cube_size; n1++ )
	for( int n2 = 0; n2 < cube_size; n2++ ) {
		if( n1 == n2 ) continue;
		MessagePtr pm = measure.generate();
		pm-> source = n1;
		pm-> truesource = n1;
		pm-> dest = n2;
		pm-> length = message_length;
		pm-> arrival = 0;
		pm-> reuse = false;
#ifdef CASTINT
		messagestart( *(int*)(&pm) );
#else
		messagestart( pm );
#endif
	}
}
