/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xktray.h"
#include <klocale.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <qcheckbox.h>
#include "xeobject.h"

#include <kxdocker_setup_sources.h>


#include "xktray.moc"


XKTray::XKTray(QWidget *parent, const char *name)
 : KSystemTray(parent, name)
{
	XEObject::xPluginAdd(this);
}


XKTray::~XKTray()
{
	XEObject::xPluginDel(this);
}



/*!
    \fn XKTray::xWarning(const QString &)
 */
void XKTray::xWarning(const QString &Message)
{
	qWarning(i18n(Message));
}


/*!
    \fn XKTray::xWarningMsg(const Object *, const QString &)
 */
void XKTray::xWarningMsg(const QObject *Sender, const QString &Message)
{
	QString WarningMsg=Sender->name();
	WarningMsg=WarningMsg+": "+i18n(Message);
	qWarning(WarningMsg);
}


/*!
    \fn XKTray::xSetup()
 */
void XKTray::xSetup()
{
	// Emits Signal of warning
#ifndef ENABLE_FINAL
	xWarningMsg(this,"xSetup");
#endif
	xActiveIcon=loadIcon("kxdocker");
	setPixmap(xActiveIcon);
	
	// setup the popup configurations
	KPopupMenu *Menu=contextMenu();
	Menu->setCheckable ( true);
	Menu->insertTitle(loadIcon("window_new"),"Task manager");
	//QCheckBox	*aaaa=new QCheckBox("Show windows from all desktops",NULL);
	//Menu->insertItem(aaaa);
	//m_popup->setItemChecked(m_selectedItem, false);
	QObject	*xTaskManager=XEObject::xFindObject("xTaskManager");
	idShowAll=0;
	if(xTaskManager)
	{
		idShowAll=Menu->insertItem(loadIcon("desktop"),"Show windows from all desktops",
			this,SLOT(xToggleShowAll()));
		connect
		(
			this,
			SIGNAL(xTaskMgr_GetParameter(const QString, int&)),
			xTaskManager,
			SLOT(xGetParameter(const QString, int&))
		);
		connect
		(
			this,
			SIGNAL(xToggleShowAllDispatch()),
			xTaskManager,
			SLOT(xToggleShowAll())
		);
		
		int allshow=0;
		if(allshow==0)
		{
			Menu->setItemChecked(idShowAll, false);
		}
		else
		{
			Menu->setItemChecked(idShowAll, true);
		}
		xTaskMgr_GetParameter(QString("showWindowsOnlyFromThisDesktop"),allshow);
	}
	
	if(XEObject::xFindObject("xConfigurator")!=NULL)
	{
	Menu->insertTitle(loadIcon("configure"),"Setup docker");
	Menu->insertItem(loadIcon("iconthemes"),"Configurator",
		XEObject::xFindObject("xConfigurator"),SLOT(xConfigure()));
	}
	/*
	Menu->insertItem(loadIcon("desktop"),"Show windows from all desktops",
		this,SLOT(RunLastCmd()));
	*/
}


/*!
    \fn XKTray::xStart()
 */
void XKTray::xStart()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"xStart");
#endif
	show();
}


/*!
    \fn XKTray::xStop()
 */
void XKTray::xStop()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"xStop");
#endif
	hide();

}


/*!
    \fn XKTray::xToggleShowAll()
 */
void XKTray::xToggleShowAll()
{
	KPopupMenu *Menu=contextMenu();
	xToggleShowAllDispatch();
		int allshow=0;
		if(allshow==0)
		{
			Menu->setItemChecked(idShowAll, false);
		}
		else
		{
			Menu->setItemChecked(idShowAll, true);
		}
}


/*!
    \fn XKTray::xGetParameter(const QString,QString&)
 */
void XKTray::xGetParameter(const QString,QString&)
{
    /// @todo implement me
}


/*!
    \fn XKTray::xGetParameterList(QStringList*)
 */
void XKTray::xGetParameterList(QStringList*)
{
    /// @todo implement me
}
