/*
 * dslk.h -- SunOS header file for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/* $Id: dlslk.h,v 1.6 99/11/10 15:01:47 abe Exp $ */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
 

#if	!defined(DLSLK_H_SUNOS)
#define	DLSLK_H_SUNOS	1

#include <kvm.h>
#include <fcntl.h>
#include <memory.h>
#include <mntent.h>
#include <nlist.h>
#include <setjmp.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/fcntlcom.h>
#include <sys/proc.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/sysmacros.h>
#include <sys/time.h>
#include <sys/user.h>
#include <sys/vnode.h>

#include <ufs/lockf.h>

#define	KERNEL
#include <ufs/inode.h>
#undef	KERNEL


/*
 * Local definitions
 */

# if	defined(NOCONST)
#define	COMP_P		void		/* qsort() compare pointer type */
# else	/* !defined(NOCONST) */
#define	COMP_P		const void	/* qsort() compare pointer type */
# endif	/* defined(NOCONST) */

#define	KA_T		off_t		/* kernel address type for kread() */
#define	LMEMCPY_P	char		/* local memcpy() type */
#define	lmemcpy		memcpy		/* local memcpy() */
#define	MALLOC_P	char		/* malloc() pointer cast */
#define	MALLOC_S	unsigned	/* malloc() size cast */
#define	N_UNIX		"/vmunix"	/* name list path */
#define	QSORT_P		char		/* qsort() table pointer type */


/*
 * Erstatz strerror()
 */

extern char *sys_errlist[];
#define strerror(errno) sys_errlist[errno]

/*
 * Nl indexes
 */

#define	X_IHEAD		0


/*
 * Local structure definitions
 */

# if	solaris==20500
struct SysIDs {				/* local sysid information */
	sysid_t id;			/* the sysid */
	char *hn;			/* the associated host name */
	ulong na;			/* the associated network address */
};
# endif	/* solaris==20500 */


/*
 * Local global variables
 */

extern kvm_t *Kd;
extern struct nlist Nl[];

# endif	/* defined(DLSLK_H_SUNOS) */
