// 
// $Id: qaregexperror.cpp,v 1.3 1999/07/22 01:57:35 amos Exp $
//
// Implementation of QaRegExpError class
//
// Jan Borsodi <amos@abn.hibu.no>
// Created on: <21-Jul-1999 23:16:38 amos>
//
// Copyright (C) 1999 Jan Borsodi.  All rights reserved.
//


#include "qaregexperror.hpp"
#include <qstring.h>
#include <regex.h>

/*!
  \class QaRegExpError qaregexperror.hpp
  \brief

*/

/*!
  Default constructor
*/

QaRegExpError::QaRegExpError( int err, const QString &s )
    : Str( s )
{
    switch ( err )
    {
        case REG_BADRPT:
            Error = BadPointer;
            break;
        case REG_BADBR:
            Error = BadBackReference;
            break;
        case REG_EBRACE:
            Error = UnmatchedBrace;
            break;
        case REG_EBRACK:
            Error = UnmatchedBracket;
            break;
        case REG_ERANGE:
            Error = InvalidRange;
            break;
        case REG_ECTYPE:
            Error = UnknownClass;
            break;
        case REG_ECOLLATE:
            Error = InvalidCollate;
            break;
        case REG_EPAREN:
            Error = UnmatchedParenthesis;
            break;
        case REG_ESUBREG:
            Error = InvalidBackReference;
            break;
        case REG_EEND:
            Error = NonPosixError;
            break;
        case REG_EESCAPE:
            Error = TrailingBackslash;
            break;
        case REG_BADPAT:
            Error = BadPattern;
            break;
        case REG_ESIZE:
            Error = BufferOverflow;
            break;
        case REG_ESPACE:
            Error = OutOfMemory;
            break;
        default:
            Error = UnknownError;
    }
}

/*!
  Destroys the object
*/

QaRegExpError::~QaRegExpError()
{
}

/*!
  \return Text explaining the error.
*/

const QString &QaRegExpError::error() const
{
    return Str;
}

/*!
  \return The error code that caused this exception.
*/

QaRegExpError::RegExpCode QaRegExpError::errorCode() const
{
    return Error;
}
