<?php	// TWIG		Schedule Feature Module ?>
<?php  $session["action-return"] = "week"; ?>

<?php echo TWIGScheduleMenu(); ?>

<?php
 // We need to setup some time's so we can calculate things later...
 $ts = mktime( 0, 0, 0, $TWIGScheduleDate["month"], $TWIGScheduleDate["day"], $TWIGScheduleDate["year"] );
 $tday = date( "w", $ts ) - $config["firstdayweek"];
 if ($tday < 0) { $tday = 7 + $tday; }

 // Ok the next lines need some explaining, first we use mktime() to create a unix time stamp that will 
 // deal with date wraps (like when a week spans a month or year), then we use date() to get back the year (Y).
 // month number (n), and day number (j).  Then we use explode to split them up so we can use them in the
 // createsqldatetime() call and other places.  
 $wstart = mktime( 0, 0, 0, $TWIGScheduleDate["month"],  $TWIGScheduleDate["day"] - $tday, $TWIGScheduleDate["year"] );
 $wstop = mktime( 23, 59, 59, $TWIGScheduleDate["month"],  $TWIGScheduleDate["day"] - $tday + 6, $TWIGScheduleDate["year"] );
 $stime = explode( " ", date( "Y n j", $wstart ) );
 $etime = explode( " ", date( "Y n j", $wstop ) );

 $weekstart = createSqlDateTime( $stime[0], $stime[1], $stime[2], 0, 0, 0 );
 $weekstop  = createSqlDateTime( $etime[0], $etime[1], $etime[2], 23, 59, 59 );
?>
<table width=100% border=0>
 <tr>
  <td>
   <font face="<?php echo $config["cellfont"]; ?>" size=<?php echo $config["textfontsize"];?>>
    <?php 
	$sother = array( array( "item"=>"schcurdate", "value"=>mktime( 0, 0, 0, $TWIGScheduleDate["month"], $TWIGScheduleDate["day"] - 7, $TWIGScheduleDate["year"] ) ) );
	echo twigLink( $TWIGphrase["Previous&nbsp;Week"], "schedule", "week", "", "", $sother ); 
    ?>
   </font>
  </td>
  <td width=99% align=center>
   <font face="<?php echo $config["cellfont"]; ?>" size=<?php echo $config["textfontsize"];?>>
   <?php echo $TWIGphrase["Week"] . ": " . intval( ( date( "z", $ts ) / 7 ) + 1 ); ?><BR><?php echo $TWIGphrase["The week starts on "] . TWIGdate( $config["longdateformat"], $wstart ) . $TWIGphrase[" and ends on "] . TWIGdate( $config["longdateformat"], $wstop ); ?>
   </font>
  </td>
  <td>
   <font face="<?php echo $config["cellfont"]; ?>" size=<?php echo $config["textfontsize"];?>>
    <?php 
	$sother = array( array( "item"=>"schcurdate", "value"=>mktime( 0, 0, 0, $TWIGScheduleDate["month"], $TWIGScheduleDate["day"] + 7, $TWIGScheduleDate["year"] ) ) );
	echo twigLink( $TWIGphrase["Next&nbsp;Week"], "schedule", "week", "", "", $sother ); 
    ?>
   </font>
  </td>
 </tr>
</table>
<?php
 $headers = array(
 	$TWIGphrase["Status"],
	$TWIGphrase["Start Time"],
	$TWIGphrase["End Time"],
	$TWIGphrase["Group"],
	$TWIGphrase["Subject"],
	$TWIGphrase["Description"]
	);

 list( $allentries, $timeentries, $notimeentires ) = TWIGScheduleGetItems( $wstart, $wstop );

 $cdate = $weekstart;

 for( $i = 0, $k = 0, $j = count( $allentries ); $i < $j; $i++, $k++ )
	{
	if( !$allentries[$i]["item"] ) { $allentries[$i]["item"] = "[no name]"; }

	$eventstart = convertSQLTimetoUTime( $allentries[$i]["itemstart"] );
	$eventstop = convertSQLTimetoUTime( $allentries[$i]["itemstop"] );

	if( $eventstart > $cday )
		{
		$contents[$k][0] = array( "contents"=>"<B>" . TWIGdate( "l", $eventstart ) . "</B>", "colspan"=>"5" );
		$k++;
 		$cday = mktime( 0, 0, 0, date( "m", $eventstart), date( "d", $eventstart) + 1, date( "Y", $eventstart) );
		}

	$contents[$k][0] = twigLink( TWIGImage( $img["appointment"], "*" ), "schedule", "view", "action=Edit&ItemID=" . $allentries[$i]["id"] );

	if( $allentries[$i]["notime"] )
		{
		$contents[$k][1] = TWIGdate( $config["shortdateformat"], $eventstart ) . " " . $TWIGphrase["[None]"];
		$contents[$k][2] = TWIGdate( $config["shortdateformat"], $eventstop ) . " " . $TWIGphrase["[None]"];
		}
	else
		{
		$contents[$k][1] = TWIGdate( $config["shortdateformat"] . " " . TWIGGetTimeFormat(), $eventstart );
		$contents[$k][2] = TWIGdate( $config["shortdateformat"] . " " . TWIGGetTimeFormat(), $eventstop );
		}
	$contents[$k][3] = twigLink( TWIGGroupsGetName( $allentries[$i]["groupid"] ), "", "", "data_thisGroup=" . $allentries[$i]["groupid"] );
	$contents[$k][4] = twigLink( $allentries[$i]["item"], "schedule", "view", "action=Edit&ItemID=" . $allentries[$i]["id"] );
	$contents[$k][5] = $allentries[$i]["description"];
	}

 TWIGGenerateTable( $headers, $contents );
?>
