#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "editor.h"
#include "editoridialog.h"
#include "editoridialogcb.h"

#ifdef MEMWATCH
# include "memwatch.h"
#endif


gint EditorIDialogKeyEventCB(
	GtkWidget *widget, GdkEventKey *event, gpointer data
);
void EditorIDialogDestroyCB(GtkObject *object, gpointer data);
gint EditorIDialogCloseCB(
	GtkWidget *widget, gpointer event, gpointer data
);
void EditorIDialogButtonCB(GtkWidget *widget, gpointer data);


/*
 *	Key event callback.
 */
gint EditorIDialogKeyEventCB(GtkWidget *widget, GdkEventKey *event, gpointer data)
{
	static gbool reenterant = FALSE;
	gbool status = FALSE;
        GtkWidget *w;
        ma_editor_idialog_struct *d = (ma_editor_idialog_struct *)data;
        if((widget == NULL) ||
           (event == NULL) ||
           (d == NULL)
        )
            return(FALSE);

#define CHECK_ISDEFAULT ((w == NULL) ? 0 : GTK_WIDGET_HAS_DEFAULT(w))

	if(reenterant)
	    return(FALSE);
	else
	    reenterant = TRUE;

        switch(event->keyval)
        {
          /* Escape. */
          case GDK_Escape: 
            if(!event->state)
		EditorIDialogButtonCB(d->cancel_btn, d);
	    status = TRUE;
            break;

          /* Enter or space. */
          case GDK_KP_Enter: case GDK_KP_Space:
          case '\n': case '\r':
            if(!event->state)
	    {
              w = d->ok_btn;
              if(CHECK_ISDEFAULT)
                EditorIDialogButtonCB(d->ok_btn, d);
              w = d->apply_btn;
              if(CHECK_ISDEFAULT)
                EditorIDialogButtonCB(d->apply_btn, d);
              w = d->cancel_btn;
              if(CHECK_ISDEFAULT)
                EditorIDialogButtonCB(d->cancel_btn, d);
	    }
	    status = TRUE;
            break;

          case GDK_F1:
            if(!event->state)  
                break;

            w = d->help_btn;
            if(CHECK_ISDEFAULT)
                EditorIDialogButtonCB(d->help_btn, d);
	    status = TRUE;                
            break;
        }

#undef CHECK_ISDEFAULT

	reenterant = FALSE;

	return(status);
}

/*
 *	Destroy input dialog callback.
 */
void EditorIDialogDestroyCB(GtkObject *object, gpointer data)
{
	return;
}

/*
 *	Close input dialog callback.
 */
gint EditorIDialogCloseCB(GtkWidget *widget, gpointer event, gpointer data)
{
	ma_editor_struct *editor;
        ma_editor_idialog_struct *d = (ma_editor_idialog_struct *)data;
        if(d == NULL)
            return(FALSE);

	editor = d->editor_ptr;

	/* Try to call cancel callback function if not NULL,
	 * otherwise just unmap the input dialog.
	 */
	if(d->func_cancel_cb == NULL)
	    EditorIDialogUnmap(editor, d);
	else
	    d->func_cancel_cb(
		d, d->client_data
	    );

	return(TRUE);
}

/*
 *	Input dialog button (not client buttons) callback.
 */
void EditorIDialogButtonCB(GtkWidget *widget, gpointer data)
{
	ma_editor_struct *editor;
	ma_editor_idialog_struct *d = (ma_editor_idialog_struct *)data;
	if(d == NULL)
	    return;

	editor = d->editor_ptr;

	/* Handle by which button was pressed. */

	/* OK button? */
	if(widget == d->ok_btn)
	{
	    if(d->func_ok_cb != NULL)
		d->func_ok_cb(
		    d,			/* Input dialog pointer. */
		    d->client_data	/* Client data. */
		);
	}
	/* Apply button? */
	else if(widget == d->apply_btn)
	{
            if(d->func_apply_cb != NULL)
                d->func_apply_cb(
                    d,                  /* Input dialog pointer. */
                    d->client_data      /* Client data. */
                );
	}
	/* Cancel button? */
	else if(widget == d->cancel_btn)
	{
            if(d->func_cancel_cb == NULL)
                EditorIDialogUnmap(editor, d);
	    else
                d->func_cancel_cb(
                    d,                  /* Input dialog pointer. */
                    d->client_data      /* Client data. */
                );
	}
	/* Help button? */
	else if(widget == d->help_btn)
	{


	}

	return;
}
