/*
	       Vertex Model Assembler: Preferences Window
 */

#ifndef PREFWIN_H
#define PREFWIN_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Preference catagory codes:
 *
 *	Each value corresponds to a index on the panel_parent member
 *	on the vma_pref_struct.
 */
#define VMA_PREF_CAT_MAIN		0
#define VMA_PREF_CAT_APPERANCE		1
#define VMA_PREF_CAT_FONTS		2
#define VMA_PREF_CAT_COLORS		3
#define VMA_PREF_CAT_PRECISION		4
#define VMA_PREF_CAT_RENDERING		5
#define VMA_PREF_CAT_DEVICES		6
#define VMA_PREF_CAT_EDITOR		7
#define VMA_PREF_CAT_LOCATIONS		8
#define VMA_PREF_CAT_V3DFORMAT		9
#define VMA_PREF_CAT_BACKUP		10
#define VMA_PREF_CAT_PLUGINS		11


/*
 *	Parameter widget codes:
 *
 *	Each value corresponds to a index on the parm_widget member
 *	on the vma_pref_struct.
 */
#define VMA_PREF_PARM_RECORD_WIN_POS_AND_SIZES	0	/* GtkCheckButton */
#define VMA_PREF_PARM_TOOLTIPS			1	/* GtkCheckButton */
#define VMA_PREF_PARM_SHOW_TIP_OF_DAY           2	/* GtkCheckButton */

#define VMA_PREF_PARM_TOOLBAR_PT		3	/* GtkRadioButton. */
#define VMA_PREF_PARM_TOOLBAR_P			4	/* Ditto... */
#define VMA_PREF_PARM_TOOLBAR_T			5

#define VMA_PREF_PARM_FONT_EDITABLE		6	/* GtkEntry. */
#define VMA_PREF_PARM_FONT_TERMINAL		7	/* Gitto for fonts... */

#define VMA_PREF_PARM_COLOR_VIEW_BG		8	/* GtkDrawingArea */
#define VMA_PREF_PARM_COLOR_VIEW_POINT		9	/* Ditto for colors... */
#define VMA_PREF_PARM_COLOR_VIEW_LINE		10
#define VMA_PREF_PARM_COLOR_VIEW_LINE_STRIP	11
#define VMA_PREF_PARM_COLOR_VIEW_LINE_LOOP	12
#define VMA_PREF_PARM_COLOR_VIEW_TRIANGLE	13
#define VMA_PREF_PARM_COLOR_VIEW_TRIANGLE_STRIP	14
#define VMA_PREF_PARM_COLOR_VIEW_TRIANGLE_FAN	15
#define VMA_PREF_PARM_COLOR_VIEW_QUAD		16
#define VMA_PREF_PARM_COLOR_VIEW_QUAD_STRIP	17
#define VMA_PREF_PARM_COLOR_VIEW_POLYGON	18
#define VMA_PREF_PARM_COLOR_VIEW_TEXTURE_OUTLINE	19
#define VMA_PREF_PARM_COLOR_VIEW_TEXTURE_SELECTED	20
#define VMA_PREF_PARM_COLOR_VIEW_HEIGHTFIELD	21
#define VMA_PREF_PARM_COLOR_VIEW_GRID		22
#define VMA_PREF_PARM_COLOR_VIEW_SELECTED	23
#define VMA_PREF_PARM_COLOR_VIEW_SELECTED_VERTEX	24
#define VMA_PREF_PARM_COLOR_VIEW_CURSORY	25
#define VMA_PREF_PARM_COLOR_VIEW_NORMAL_VECTOR	26

#define VMA_PREF_PARM_DATA_DECIMALS_POSITION	27	/* GtkSpinButton */
#define VMA_PREF_PARM_DATA_DECIMALS_ANGLE	28	/* Ditto... */

#define VMA_PREF_PARM_VIEW_DECIMALS_POSITION	29	/* GtkSpinButton */
#define VMA_PREF_PARM_VIEW_DECIMALS_ANGLE	30	/* Ditto... */

#define VMA_PREF_PARM_VIEW_RENDER		31	/* GtkCheckButton */
#define VMA_PREF_PARM_VIEW_CULL_FACES		32	/* GtkCheckButton */
#define VMA_PREF_PARM_CULL_DIRECTION_CW		33	/* GtkRadioButton */
#define VMA_PREF_PARM_CULL_DIRECTION_CCW	34	/* GtkRadioButton */
#define VMA_PREF_PARM_VIEW_TRANSLATIONS_STATE	35	/* GtkCheckButton */
#define VMA_PREF_PARM_VIEW_ENABLE_ALPHA_CHANNEL	36	/* GtkCheckButton */

#define VMA_PREF_PARM_VIEW_CAM_CLIP_NEAR	37	/* GtkSpinButton */
#define VMA_PREF_PARM_VIEW_CAM_CLIP_FAR		38	/* Ditto... */
#define VMA_PREF_PARM_VIEW_CAM_FOV		39	

#define VMA_PREF_PARM_DEVICES_POINTER_2BUTTON	40	/* GtkCheckButton */

#define VMA_PREF_PARM_EDITOR_UNDO_MAX		41	/* GtkSpinButton */

#define VMA_PREF_PARM_DIRECTORY_LOCAL		42	/* GtkEntry */
#define VMA_PREF_PARM_DIRECTORY_GLOBAL		43	/* Ditto... */
#define VMA_PREF_PARM_DIRECTORY_PRESET_MODELS_LOCAL	44	/* Ditto... */
#define VMA_PREF_PARM_DIRECTORY_PRESET_MODELS_GLOBAL	45	/* Ditto... */
#define VMA_PREF_PARM_DIRECTORY_PRESET_PRIMITIVES_LOCAL		46	/* Ditto... */
#define VMA_PREF_PARM_DIRECTORY_PRESET_PRIMITIVES_GLOBAL	47	/* Ditto... */
#define VMA_PREF_PARM_DIRECTORY_PLUGINS_LOCAL	48	/* Ditto... */
#define VMA_PREF_PARM_DIRECTORY_PLUGINS_GLOBAL	49	/* Ditto... */
#define VMA_PREF_PARM_DIRECTORY_TMP		50	/* Ditto... */
#define VMA_PREF_PARM_FILE_SCRATCHPAD		51	/* Ditto... */
#define VMA_PREF_PARM_FILE_PLUGINS		52	/* Ditto... */

#define VMA_PREF_PARM_V3DFMT_PROMPT_ON_SAVE	53	/* GtkCheckButton */
#define VMA_PREF_PARM_V3DFMT_OPTIMIZATION	54	/* GtkScale */
#define VMA_PREF_PARM_V3DFMT_STRIP_EXTRAS	55	/* GtkCheckButton */

#define VMA_PREF_PARM_BACKUP_ON_OPEN		56	/* GtkCheckButton */
#define VMA_PREF_PARM_BACKUP_ON_SAVE		57	/* GtkCheckButton */
#define VMA_PREF_PARM_BACKUP_PERIODIC		58	/* GtkCheckButton */
#define VMA_PREF_PARM_BACKUP_PERIODIC_INT	59	/* GtkSpinButton */
#define VMA_PREF_PARM_BACKUP_NEW_HIGHEST_INDEX	60	/* GtkRadioButton */
#define VMA_PREF_PARM_BACKUP_NEW_LOWEST_INDEX	61	/* GtkRadioButton */
#define VMA_PREF_PARM_BACKUP_MAX		62	/* GtkSpinButton */

#define VMA_PREF_PARM_PLUGINS_LIST		63	/* GtkCList */
#define VMA_PREF_PARM_PLUGINS_LIST_MENU		64	/* GtkMenu */
#define VMA_PREF_PARM_PLUGINS_LIST_MENU_ENABLE	65	/* GtkMenuItem */
#define VMA_PREF_PARM_PLUGINS_LIST_MENU_DISABLE	66	/* GtkMenuItem */
#define VMA_PREF_PARM_PLUGINS_LIST_MENU_CONFIGURE	67	/* GtkMenuItem */
#define VMA_PREF_PARM_PLUGINS_ENABLE		68	/* GtkButton */
#define VMA_PREF_PARM_PLUGINS_DISABLE		69	/* GtkButton */
#define VMA_PREF_PARM_PLUGINS_RELOAD		70	/* GtkButton */
#define VMA_PREF_PARM_PLUGINS_CONFIGURE		71	/* GtkButton */
#define VMA_PREF_PARM_PLUGINS_DESCRIPTION	72	/* GtkText */



/*
 *	Branch item structure for Preferences & Options window's
 *	layout_ctree.
 */
typedef struct {

	/* One of VMA_PREF_CAT_* or -1 for none. */
	int catagory;

	/* Pointer back to vma_pref_struct structure. */
	void *pref_ptr;

} vma_pref_item_struct;


/*
 *	Preferences window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gbool has_changes;
	gbool processing;

	void *core_ptr;		/* Pointer back to core structure. */

	GdkCursor *busy_cur;

	GtkWidget *toplevel;
	GtkWidget *main_vbox;

	/* Main catagory ctree. */
	GtkWidget *catagory_ctree;
	GtkCTreeNode *selected_branch;

	/* Parent to all panel parent vboxes. */
	GtkWidget *panel_toplevel;

	/* Array of vboxes which hold various widgets depending
	 * on which branch on the catagory_ctree is selected.
	 */
	GtkWidget **panel_parent;
	int total_panel_parents;

	/* Buttons. */
	GtkWidget	*ok_btn,
			*apply_btn,
			*save_btn,
			*cancel_btn;

	/* Pointers to parameter widgets, each parameter widget holds
	 * a value (depending on widget type). The parameter widget
	 * is indexed by hard coded values defined by
	 * VMA_PREF_PARM_*.
	 */
	GtkWidget **parm_widget;
	int total_parm_widgets;

} vma_pref_struct;


extern GtkWidget *PrefParmGetWidget(vma_pref_struct *pref, int parameter);
extern GtkWidget *PrefPanelGetWidget(vma_pref_struct *pref, int catagory);
extern char *PrefPanelGetBranchText(vma_pref_struct *pref, GtkCTreeNode *branch);

extern int PrefParmRecord(
	vma_pref_struct *pref,
	int parameter,		/* One of VMA_PREF_PARM_*. */
	GtkWidget *w
);
extern int PrefPanelRecord(
	vma_pref_struct *pref,
	int catagory,		/* One of VMA_PREF_CAT_. */
	GtkWidget *w		/* A vbox. */
);

extern void *PrefParmGetValueP(
	vma_pref_struct *pref,
	int parameter		/* One of VMA_PREF_PARM_*. */
);
extern int PrefParmGetValueI(
        vma_pref_struct *pref,
        int parameter           /* One of VMA_PREF_PARM_*. */
);
extern float PrefParmGetValueF(
        vma_pref_struct *pref,
        int parameter           /* One of VMA_PREF_PARM_*. */
);
extern double PrefParmGetValueD(
        vma_pref_struct *pref,
        int parameter		/* One of VMA_PREF_PARM_*. */
);
extern gbool PrefParmGetValueB(
        vma_pref_struct *pref,
        int parameter		/* One of VMA__PREF_PARM_*. */
);

extern void PrefBranchSetData(
        GtkCTree *ctree, GtkCTreeNode *branch,
        vma_pref_item_struct *item_ptr, GtkDestroyNotify destroy
);
extern vma_pref_item_struct *PrefBranchGetData(
        GtkCTree *ctree, GtkCTreeNode *branch
);
extern void PrefSetBusy(vma_pref_struct *pref);
extern void PrefSetReady(vma_pref_struct *pref);

extern GtkCTreeNode *PrefAddCatagoryBranch(
        vma_pref_struct *pref,
        const char *catagory_name,
        GtkCTreeNode *parent, GtkCTreeNode *sibling,
        GdkPixmap *pixmap_closed, GdkBitmap *mask_closed,
        GdkPixmap *pixmap_opened, GdkBitmap *mask_opened,
        gbool is_leaf,   
        GtkWidget *panel_vbox,
        int catagory
);

extern vma_pref_struct *PrefNew(void *core_ptr);
extern void PrefUpdateMenus(vma_pref_struct *pref);
extern void PrefReset(vma_pref_struct *pref, gbool need_unmap);
extern void PrefMap(vma_pref_struct *pref);
extern void PrefUnmap(vma_pref_struct *pref);
extern void PrefDelete(vma_pref_struct *pref);


#endif	/* PREFWIN_H */
