#!/usr/bin/python

# 
# 
#
 

try:
  import os, sys
  if os.path.exists('/usr/lib/woody'):
    sys.path.append('/usr/lib/woody')
  from woody_defs import *
  import woody_tree
  #from woody_iface import *
  import woody_slang
  import woody_config
except IOError, msg:
  print "%s: Fatal Error loading program modules: %s" % (__name__, msg)
  sys.exit(1)
except ImportError, msg:
  print "%s: Fatal Error loading program modules: %s" % (__name__, msg)
  sys.exit(1)
  


# for TODO list, run "woody todo.tree"



############################################################
#
#
def woody_callback(what, data):
  global face

  if what == "file load"  or  what == "file save":
    face.callback(what, data)
    #(name, current, total) = data
    #print "Loading %s: %s / %s (%.0f%%)" % (name, current, total,
    #                                      100.0*current/total)



############################################################
# Main control function:
#
def run(my_mode=None, args=None):
  global program_name
  print "Starting %s..." % program_name

  quit = 0

  global mode
  if my_mode:
    mode = my_mode

  # TODO: parse the command line...
  # - load files, etc...
  global cfg
  cfg = woody_config.config()
  cfg.load()

  global face
  face = woody_slang.slang_iface(cfg)

  if len(args) > 1:
    import woody_xml
    #print "Loading file..."
    wood = woody_xml.load(cfg, args[1], woody_callback)
  else:
    wood = woody_tree.tree(cfg=cfg, title="<Untitled>",
                           callback=woody_callback)

  face.main_loop(cfg, wood)

  face.shutdown()


############################################################
#
#
if __name__ == '__main__':
  import sys
  
  run(args=sys.argv)

