// $Id: HeightFieldCommand.cpp,v 1.4 2003/02/27 23:43:40 zongo Exp $

#include "HeightFieldCommand.h"


HeightFieldCommand::HeightFieldCommand(World* hf, const std::string& type) :
    m_World( hf ),
    m_Type( type )
{
}


HeightFieldCommand::~HeightFieldCommand()
{
}


/// Push a new change in the state
void 
HeightFieldCommand::AddState(IndexType index, DataType data)
{
    // Computing borders is long, should be done by apply ?
    const int width = m_World->m_SizeX;
    const int z = index / width;
    const int x = index % width;

    Ark::Vector3 coord = m_World->GetCoord(x, z);
    m_ChangeBox.AddPoint(coord);

    HFCPair p;
    p.first = index;
    p.second = data;
    m_State.push_back( p );
}


//===========================================================================
//===========================================================================

void 
HFEHCommand::ExchangeState()
{

    // Use algorithm style
    for (HFCIterator i=m_State.begin() ; i!=m_State.end() ; ++i)
    {
	DataType state = i->second;
	Ark::Height& height = m_World->ArrayY( i->first );

	// store current height for next undo/redo
	i->second = height;

	// change HF
	height = (unsigned char)state;
    }
	
    m_World->Invalidate(m_ChangeBox.m_Min.X, m_ChangeBox.m_Min.Z, m_ChangeBox.m_Max.X, m_ChangeBox.m_Max.Z);
}


//===========================================================================
//===========================================================================

void 
HFCGCommand::ExchangeState()
{

    // Use algorithm style
    for (HFCIterator i=m_State.begin() ; i!=m_State.end() ; ++i)
    {
	DataType state = i->second;
	Ark::Height& height = m_World->ArrayGround( i->first );

	// store current height for next undo/redo
	i->second = height;

	// change HF
	height = (unsigned char)state;
    }
	
    m_World->Invalidate(m_ChangeBox.m_Min.X, m_ChangeBox.m_Min.Z, m_ChangeBox.m_Max.X, m_ChangeBox.m_Max.Z);
}


