// $Id: CallbacksGround.h,v 1.4 2001/10/14 21:46:24 zongo_fr Exp $
#ifndef WE_UICALLBACKS_GROUND_H
#define WE_UICALLBACKS_GROUND_H
  
#include <vector>

namespace Ark { 
  class Material;
}

/**
 * Ground operations
 */

// Open a file dialog
void AddGroundBrushDialog();

// Read a ground file to memory
bool AddGroundFile(const char* name);

// Add a ground to the list of brushes
void AddGroundToList(Ark::Material* mat);
  
// Set the ground list to the list given
void AddGroundsToList(const Ark::MaterialList& mats);
  
// Ground tool has been chosen
void UpdateGround();
    
// Ground size has been changed
void UpdateGroundSize(int size);
  
// Ground Brush Type has been changed
void UpdateGroundType(int type);
  
// A ground has been selected for painting
void SelectGround(int ground);
  
#endif // WE_UICALLBACKS_GROUND_H
