
/* This file was automatically generated with compilecpp.
*/

//#include <stdio.h>

#include "lisptype.h"
#include "lispenvironment.h"
#include "lispatom.h"
#include "standard.h"
#include "arggetter.h"
#include "lispplugin.h"
#include "platmath.h"
#include "stubs.h"
#include "genericstructs.h"
#include "mathcommands.h"

// The define OPTIMIZE_COMPILED_PLUGIN_SIZE should be defined somewhere else.
#ifndef WIN32 // some macro expansion is failing on Win platform, no idea why.
#define OPTIMIZE_COMPILED_PLUGIN_SIZE
#endif // WIN32

#ifdef OPTIMIZE_COMPILED_PLUGIN_SIZE
#include "vm.h"
#endif // OPTIMIZE_COMPILED_PLUGIN_SIZE


//#define _this_stack (aEnvironment.iStack)
#define ATOM(_x) LispAtom::New(aEnvironment,_x)
#define RESULT _this_stack.GetElement(aStackTop)
#define ARGUMENT(i) _this_stack.GetElement(aStackTop+i)

#define PUSH(_x)   _this_stack.PushArgOnStack(_x)
#define POP(_i)    _this_stack.PopTo(_this_stack.GetStackTop() - _i)
#define STACKTOP() _this_stack.GetStackTop()
#define STACK(_i)  _this_stack.GetElement(_i)

#define ISTRUE(_x) IsTrue(aEnvironment, _x)
#define ISFALSE(_x) IsFalse(aEnvironment, _x)


#ifdef OPTIMIZE_COMPILED_PLUGIN_SIZE
    #define VmFunction(name) \
      void Compiled_##name(LispEnvironment& aEnvironment,LispInt aStackTop) \
      { \
        extern const unsigned char Code_##name[]; \
        RunFunction(aEnvironment,aStackTop, Code_##name, CONSTANTS); \
      } \
      const unsigned char Code_##name[] = {
  
  #define VmFunctionEnd()        CodeVmReturn};
  
  #define VmJumpIfTrue(label)   CodeVmJumpIfTrue,  ((label)>>8)&0xff, (label)&0xff,
  #define VmJumpIfFalse(label)  CodeVmJumpIfFalse, ((label)>>8)&0xff, (label)&0xff,
  #define VmJump(label)         CodeVmJump,        ((label)>>8)&0xff, (label)&0xff,
  #define VmLabel(label)
  #define VmPushNulls(_nr)       CodeVmPushNulls,_nr,
  #define VmPush(_index)         CodeVmPush,_index,
  #define VmPushConstant(_constnt) CodeVmPushConstant,((_constnt)>>8)&0xff, (_constnt)&0xff,
  #define VmInitRegister(_index,_constnt) CodeVmInitRegister,_index,((_constnt)>>8)&0xff, (_constnt)&0xff,
  #define VmSetRegister(_index)   CodeVmSetRegister,_index,
  #define VmPop(_i)               CodeVmPop,_i,
  #if (BITS_PER_LONG==32)
    #define VmCall(fname,nrargs)     CodeVmCall,(((long)fname)>>24)&0xff, (((long)fname)>>16)&0xff,(((long)fname)>>8)&0xff, ((long)fname)&0xff,nrargs,
  #endif
  #if (BITS_PER_LONG==64)
    #define VmCall(fname,nargs)     CodeVmCall, \
                                      (((long)fname)>>56)&0xff, (((long)fname)>>48)&0xff, \
                                      (((long)fname)>>40)&0xff, (((long)fname)>>32)&0xff, \
                                      (((long)fname)>>24)&0xff, (((long)fname)>>16)&0xff, \
                                      (((long)fname)>>8)&0xff, ((long)fname)&0xff,nrargs,
  #endif
  
  #define VmConsList(_n)          CodeVmConsList,_n,
#else


  #define VmFunction(name)    void Compiled_##name(LispEnvironment& aEnvironment,LispInt aStackTop) { register LispEnvironment::YacasArgStack& _this_stack = aEnvironment.iStack; 
  #define VmFunctionEnd()        }
  
  #define VmJumpIfTrue(_label)   if (ISTRUE (STACK(STACKTOP()-1))) goto _label;
  #define VmJumpIfFalse(_label)  if (ISFALSE(STACK(STACKTOP()-1))) goto _label;
  #define VmJump(_label)         goto _label;
  #define VmLabel(_label)          _label:;
  
  #define VmPushNulls(_nr)            _this_stack.PushNulls(_nr);
  #define VmPush(_index)          PUSH(ARGUMENT(_index).Get());
  #define VmPushConstant(_constnt) PUSH(CONSTANTS[_constnt]);
  
  #define VmInitRegister(_index,_constant) ARGUMENT(_index).Set(CONSTANTS[_constant]);
  #define VmSetRegister(_index) ARGUMENT(_index).Set(STACK(STACKTOP()-1).Get());
  
  #define VmPop(_i)               _this_stack.PopTo(_this_stack.GetStackTop() - _i);
  #define VmCall(fname,nargs)     fname(aEnvironment,STACKTOP()-(nargs+1) );
  
  
  #define VmConsList(_n)                                                     \
    {                                                                       \
      LispInt i,stacktop = STACKTOP();                                      \
      for (i=0;i<_n;i++)                                                    \
      {                                                                     \
        STACK(stacktop-2).Set(STACK(stacktop-2).Get()->Copy(LispFalse));    \
        STACK(stacktop-2).Get()->Next().Set(STACK(stacktop-1).Get());       \
        POP(1);  stacktop--;                                                \
      }                                                                     \
      STACK(stacktop-1).Set(LispSubList::New(STACK(stacktop-1).Get()));     \
    }

#endif // OPTIMIZE_COMPILED_PLUGIN_SIZE

static LispObject* CONSTANTS[24];

#ifdef OPTIMIZE_COMPILED_PLUGIN_SIZE
#define C57 (4*BitsPerLong)/8+79 
#define C59 (4*BitsPerLong)/8+79 
#define C61 (4*BitsPerLong)/8+79 
#define C60 (4*BitsPerLong)/8+74 
#define C58 (2*BitsPerLong)/8+46 
#define C56 BitsPerLong/8+22 
#define C51 (13*BitsPerLong)/8+139 
#define C53 (13*BitsPerLong)/8+139 
#define C55 (13*BitsPerLong)/8+139 
#define C54 (12*BitsPerLong)/8+129 
#define C52 (5*BitsPerLong)/8+66 
#define C50 BitsPerLong/8+22 
#define C49 (6*BitsPerLong)/8+65 
#define C48 (3*BitsPerLong)/8+38 
#define C47 (4*BitsPerLong)/8+79 
#define C46 27 
#define C45 (9*BitsPerLong)/8+140 
#define C44 (3*BitsPerLong)/8+67 
#define C43 (13*BitsPerLong)/8+173 
#define C42 (6*BitsPerLong)/8+91 
#define C41 (18*BitsPerLong)/8+231 
#define C40 (7*BitsPerLong)/8+97 
#define C33 (9*BitsPerLong)/8+134 
#define C35 (9*BitsPerLong)/8+134 
#define C37 (9*BitsPerLong)/8+134 
#define C36 (9*BitsPerLong)/8+129 
#define C39 (9*BitsPerLong)/8+126 
#define C38 (8*BitsPerLong)/8+114 
#define C34 (2*BitsPerLong)/8+46 
#define C32 BitsPerLong/8+22 
#define C23 (9*BitsPerLong)/8+190 
#define C25 (9*BitsPerLong)/8+190 
#define C27 (9*BitsPerLong)/8+190 
#define C29 (9*BitsPerLong)/8+186 
#define C31 (7*BitsPerLong)/8+152 
#define C30 (7*BitsPerLong)/8+152 
#define C28 (3*BitsPerLong)/8+98 
#define C26 (3*BitsPerLong)/8+96 
#define C24 (2*BitsPerLong)/8+73 
#define C22 BitsPerLong/8+37 

#endif // OPTIMIZE_COMPILED_PLUGIN_SIZE

extern void Compiled_PositiveIntPower(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathIntPower(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_Trigonometry(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathSin(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathCos(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathTan(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathArcSin(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathExpTaylor0(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathExpDoubling(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathMul2Exp(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathExp(LispEnvironment& aEnvironment,LispInt aStackTop);
extern void Compiled_MathPower(LispEnvironment& aEnvironment,LispInt aStackTop);




VmFunction(PositiveIntPower)
  VmPushNulls(2 )
/* Local(result,unit)  */
  VmInitRegister(/*ARGUMENT*/(3 ), 0)
  VmInitRegister(/*ARGUMENT*/(4 ), 1)
  VmPushConstant(2)
  VmPop(1)
/* If (LessThan(n,0) ) False  */
/* else [Set(unit,1);Set(result,unit);If(Equals(n,0),unit,If(Equals(n,1),x,[While(GreaterThan(n,0))[If(Equals(BitAnd(n,1),1),Set(result,MathMultiply(result,x)));Set(x,MathMultiply(x,x));Set(n,ShiftRight(n,1));];result;]));]  */
  VmPushNulls(1)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispLessThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C22 )
  VmPop(1)
/* atom : False  */
  VmPushConstant(4)
  VmJump(C23 )
VmLabel(C22 )
  VmPop(1)
/* Set(unit,1)  */
/* number : 1  */
  VmPushConstant(5)
  VmSetRegister(/*ARGUMENT*/(4))
  VmPop(1)
/* Set(result,unit)  */
/* local : unit  */
  VmPush(/*ARGUMENT*/(4))
  VmSetRegister(/*ARGUMENT*/(3))
  VmPop(1)
/* If (Equals(n,0) ) unit  */
/* else If(Equals(n,1),x,[While(GreaterThan(n,0))[If(Equals(BitAnd(n,1),1),Set(result,MathMultiply(result,x)));Set(x,MathMultiply(x,x));Set(n,ShiftRight(n,1));];result;])  */
  VmPushNulls(1)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispEquals, 2 )
  VmPop(2 )
  VmJumpIfFalse(C24 )
  VmPop(1)
/* local : unit  */
  VmPush(/*ARGUMENT*/(4))
  VmJump(C25 )
VmLabel(C24 )
  VmPop(1)
/* If (Equals(n,1) ) x  */
/* else [While(GreaterThan(n,0))[If(Equals(BitAnd(n,1),1),Set(result,MathMultiply(result,x)));Set(x,MathMultiply(x,x));Set(n,ShiftRight(n,1));];result;]  */
  VmPushNulls(1)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispEquals, 2 )
  VmPop(2 )
  VmJumpIfFalse(C26 )
  VmPop(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmJump(C27 )
VmLabel(C26 )
  VmPop(1)
/* While (GreaterThan(n,0) ) */
VmLabel(C28 )
  VmPushNulls(1)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispGreaterThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C29 )
/* If (Equals(BitAnd(n,1),1) ) Set(result,MathMultiply(result,x))  */
  VmPushNulls(1)
  VmPushNulls(1)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispBitAnd, 2 )
  VmPop(2 )
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispEquals, 2 )
  VmPop(2 )
  VmJumpIfFalse(C30 )
  VmPop(1)
/* Set(result,MathMultiply(result,x))  */
  VmPushNulls(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(3))
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispMultiply, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(3))
  VmJump(C31 )
VmLabel(C30 )
VmLabel(C31 )
  VmPop(1)
/* Set(x,MathMultiply(x,x))  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispMultiply, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(1))
  VmPop(1)
/* Set(n,ShiftRight(n,1))  */
  VmPushNulls(1)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispShiftRight, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(2))
  VmPop(2)
  VmJump(C28 )
VmLabel(C29 )
  VmPop(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(3))
VmLabel(C27 )
VmLabel(C25 )
VmLabel(C23 )
  VmSetRegister(0/*RESULT*/)
  VmPop(3 )
VmFunctionEnd() /* (9*BitsPerLong)/8+194  bytes in byte code mode. */


VmFunction(MathIntPower)
/* If (Equals(x,0) ) 0  */
/* else If(Equals(x,1),1,If(IsInteger(y),If(LessThan(y,0),MathDivide(1,PositiveIntPower(MathAdd(x,0.),MathNegate(y))),PositiveIntPower(x,y)),False))  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispEquals, 2 )
  VmPop(2 )
  VmJumpIfFalse(C32 )
  VmPop(1)
/* number : 0  */
  VmPushConstant(3)
  VmJump(C33 )
VmLabel(C32 )
  VmPop(1)
/* If (Equals(x,1) ) 1  */
/* else If(IsInteger(y),If(LessThan(y,0),MathDivide(1,PositiveIntPower(MathAdd(x,0.),MathNegate(y))),PositiveIntPower(x,y)),False)  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispEquals, 2 )
  VmPop(2 )
  VmJumpIfFalse(C34 )
  VmPop(1)
/* number : 1  */
  VmPushConstant(5)
  VmJump(C35 )
VmLabel(C34 )
  VmPop(1)
/* If (IsInteger(y) ) If(LessThan(y,0),MathDivide(1,PositiveIntPower(MathAdd(x,0.),MathNegate(y))),PositiveIntPower(x,y))  */
/* else False  */
  VmPushNulls(1)
/* local : y  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(LispIsInteger, 1 )
  VmPop(1 )
  VmJumpIfFalse(C36 )
  VmPop(1)
/* If (LessThan(y,0) ) MathDivide(1,PositiveIntPower(MathAdd(x,0.),MathNegate(y)))  */
/* else PositiveIntPower(x,y)  */
  VmPushNulls(1)
/* local : y  */
  VmPush(/*ARGUMENT*/(2))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispLessThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C38 )
  VmPop(1)
  VmPushNulls(1)
/* number : 1  */
  VmPushConstant(5)
  VmPushNulls(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 0.  */
  VmPushConstant(6)
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmPushNulls(1)
/* local : y  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
  VmCall(Compiled_PositiveIntPower, 2 )
  VmPop(2 )
  VmCall(LispDivide, 2 )
  VmPop(2 )
  VmJump(C39 )
VmLabel(C38 )
  VmPop(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* local : y  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(Compiled_PositiveIntPower, 2 )
  VmPop(2 )
VmLabel(C39 )
  VmJump(C37 )
VmLabel(C36 )
  VmPop(1)
/* atom : False  */
  VmPushConstant(4)
VmLabel(C37 )
VmLabel(C35 )
VmLabel(C33 )
  VmSetRegister(0/*RESULT*/)
  VmPop(1 )
VmFunctionEnd() /* (9*BitsPerLong)/8+138  bytes in byte code mode. */


VmFunction(Trigonometry)
  VmPushNulls(5 )
/* Local(x2,orig,eps,previousPrec,newPrec)  */
  VmInitRegister(/*ARGUMENT*/(5 ), 7)
  VmInitRegister(/*ARGUMENT*/(6 ), 8)
  VmInitRegister(/*ARGUMENT*/(7 ), 9)
  VmInitRegister(/*ARGUMENT*/(8 ), 10)
  VmInitRegister(/*ARGUMENT*/(9 ), 11)
  VmPushConstant(2)
  VmPop(1)
/* Set(previousPrec,GetPrecision())  */
  VmPushNulls(1)
  VmCall(LispGetPrecision, 0 )
  VmSetRegister(/*ARGUMENT*/(8))
  VmPop(1)
/* Set(newPrec,MathAdd(GetPrecision(),2))  */
  VmPushNulls(1)
  VmPushNulls(1)
  VmCall(LispGetPrecision, 0 )
/* number : 2  */
  VmPushConstant(12)
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(9))
  VmPop(1)
/* Set(x2,MathMultiply(x,x))  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispMultiply, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(5))
  VmPop(1)
  VmPushNulls(1)
/* local : newPrec  */
  VmPush(/*ARGUMENT*/(9))
  VmCall(LispPrecision, 1 )
  VmPop(1 )
  VmPop(1)
/* Set(eps,MathIntPower(10,MathNegate(previousPrec)))  */
  VmPushNulls(1)
/* number : 10  */
  VmPushConstant(13)
  VmPushNulls(1)
/* local : previousPrec  */
  VmPush(/*ARGUMENT*/(8))
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
  VmCall(Compiled_MathIntPower, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(7))
  VmPop(1)
/* While (GreaterThan(MathAbs(term),eps) ) */
VmLabel(C40 )
  VmPushNulls(1)
  VmPushNulls(1)
/* local : term  */
  VmPush(/*ARGUMENT*/(4))
  VmCall(LispAbs, 1 )
  VmPop(1 )
/* local : eps  */
  VmPush(/*ARGUMENT*/(7))
  VmCall(LispGreaterThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C41 )
/* Set(term,MathMultiply(term,x2))  */
  VmPushNulls(1)
/* local : term  */
  VmPush(/*ARGUMENT*/(4))
/* local : x2  */
  VmPush(/*ARGUMENT*/(5))
  VmCall(LispMultiply, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(4))
  VmPop(1)
/* Set(i,MathAdd(i,1.0))  */
  VmPushNulls(1)
/* local : i  */
  VmPush(/*ARGUMENT*/(2))
/* number : 1.0  */
  VmPushConstant(14)
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(2))
  VmPop(1)
/* Set(term,MathDivide(term,i))  */
  VmPushNulls(1)
/* local : term  */
  VmPush(/*ARGUMENT*/(4))
/* local : i  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(LispDivide, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(4))
  VmPop(1)
/* Set(i,MathAdd(i,1.0))  */
  VmPushNulls(1)
/* local : i  */
  VmPush(/*ARGUMENT*/(2))
/* number : 1.0  */
  VmPushConstant(14)
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(2))
  VmPop(1)
/* Set(term,MathDivide(MathNegate(term),i))  */
  VmPushNulls(1)
  VmPushNulls(1)
/* local : term  */
  VmPush(/*ARGUMENT*/(4))
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
/* local : i  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(LispDivide, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(4))
  VmPop(1)
  VmPushNulls(1)
/* local : previousPrec  */
  VmPush(/*ARGUMENT*/(8))
  VmCall(LispPrecision, 1 )
  VmPop(1 )
  VmPop(1)
/* Set(sum,MathAdd(sum,term))  */
  VmPushNulls(1)
/* local : sum  */
  VmPush(/*ARGUMENT*/(3))
/* local : term  */
  VmPush(/*ARGUMENT*/(4))
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(3))
  VmPop(1)
  VmPushNulls(1)
/* local : newPrec  */
  VmPush(/*ARGUMENT*/(9))
  VmCall(LispPrecision, 1 )
  VmPop(1 )
  VmPop(2)
  VmJump(C40 )
VmLabel(C41 )
  VmPop(1)
  VmPushNulls(1)
/* local : previousPrec  */
  VmPush(/*ARGUMENT*/(8))
  VmCall(LispPrecision, 1 )
  VmPop(1 )
  VmPop(1)
/* local : sum  */
  VmPush(/*ARGUMENT*/(3))
  VmSetRegister(0/*RESULT*/)
  VmPop(6 )
VmFunctionEnd() /* (19*BitsPerLong)/8+249  bytes in byte code mode. */


VmFunction(MathSin)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 1.0  */
  VmPushConstant(14)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(Compiled_Trigonometry, 4 )
  VmPop(4 )
  VmSetRegister(0/*RESULT*/)
  VmPop(1 )
VmFunctionEnd() /* BitsPerLong/8+19  bytes in byte code mode. */


VmFunction(MathCos)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 0.0  */
  VmPushConstant(15)
/* number : 1.0  */
  VmPushConstant(14)
/* number : 1.0  */
  VmPushConstant(14)
  VmCall(Compiled_Trigonometry, 4 )
  VmPop(4 )
  VmSetRegister(0/*RESULT*/)
  VmPop(1 )
VmFunctionEnd() /* BitsPerLong/8+21  bytes in byte code mode. */


VmFunction(MathTan)
  VmPushNulls(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(Compiled_MathSin, 1 )
  VmPop(1 )
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(Compiled_MathCos, 1 )
  VmPop(1 )
  VmCall(LispDivide, 2 )
  VmPop(2 )
  VmSetRegister(0/*RESULT*/)
  VmPop(1 )
VmFunctionEnd() /* (3*BitsPerLong)/8+26  bytes in byte code mode. */


VmFunction(MathArcSin)
  VmPushNulls(6 )
/* Local(result,eps)  */
  VmInitRegister(/*ARGUMENT*/(2 ), 0)
  VmInitRegister(/*ARGUMENT*/(3 ), 9)
  VmPushConstant(2)
  VmPop(1)
/* Set(result,FastArcSin(int1))  */
  VmPushNulls(1)
/* local : int1  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispFastArcSin, 1 )
  VmPop(1 )
  VmSetRegister(/*ARGUMENT*/(2))
  VmPop(1)
/* Local(x,q,s,c)  */
  VmInitRegister(/*ARGUMENT*/(4 ), 16)
  VmInitRegister(/*ARGUMENT*/(5 ), 17)
  VmInitRegister(/*ARGUMENT*/(6 ), 18)
  VmInitRegister(/*ARGUMENT*/(7 ), 19)
  VmPushConstant(2)
  VmPop(1)
/* Set(q,MathSubtract(MathSin(result),int1))  */
  VmPushNulls(1)
  VmPushNulls(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(Compiled_MathSin, 1 )
  VmPop(1 )
/* local : int1  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispSubtract, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(5))
  VmPop(1)
/* Set(eps,MathIntPower(10,MathNegate(GetPrecision())))  */
  VmPushNulls(1)
/* number : 10  */
  VmPushConstant(13)
  VmPushNulls(1)
  VmPushNulls(1)
  VmCall(LispGetPrecision, 0 )
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
  VmCall(Compiled_MathIntPower, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(3))
  VmPop(1)
/* While (GreaterThan(MathAbs(q),eps) ) */
VmLabel(C42 )
  VmPushNulls(1)
  VmPushNulls(1)
/* local : q  */
  VmPush(/*ARGUMENT*/(5))
  VmCall(LispAbs, 1 )
  VmPop(1 )
/* local : eps  */
  VmPush(/*ARGUMENT*/(3))
  VmCall(LispGreaterThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C43 )
/* Set(s,MathSubtract(int1,MathSin(result)))  */
  VmPushNulls(1)
/* local : int1  */
  VmPush(/*ARGUMENT*/(1))
  VmPushNulls(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(Compiled_MathSin, 1 )
  VmPop(1 )
  VmCall(LispSubtract, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(6))
  VmPop(1)
/* Set(c,MathCos(result))  */
  VmPushNulls(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(Compiled_MathCos, 1 )
  VmPop(1 )
  VmSetRegister(/*ARGUMENT*/(7))
  VmPop(1)
/* Set(q,MathDivide(s,c))  */
  VmPushNulls(1)
/* local : s  */
  VmPush(/*ARGUMENT*/(6))
/* local : c  */
  VmPush(/*ARGUMENT*/(7))
  VmCall(LispDivide, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(5))
  VmPop(1)
/* Set(result,MathAdd(result,q))  */
  VmPushNulls(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(2))
/* local : q  */
  VmPush(/*ARGUMENT*/(5))
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(2))
  VmPop(2)
  VmJump(C42 )
VmLabel(C43 )
  VmPop(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(2))
  VmSetRegister(0/*RESULT*/)
  VmPop(7 )
VmFunctionEnd() /* (13*BitsPerLong)/8+181  bytes in byte code mode. */


VmFunction(MathExpTaylor0)
  VmPushNulls(4 )
/* Local(i,aResult,term,eps)  */
  VmInitRegister(/*ARGUMENT*/(2 ), 20)
  VmInitRegister(/*ARGUMENT*/(3 ), 21)
  VmInitRegister(/*ARGUMENT*/(4 ), 22)
  VmInitRegister(/*ARGUMENT*/(5 ), 9)
  VmPushConstant(2)
  VmPop(1)
/* Set(i,0)  */
/* number : 0  */
  VmPushConstant(3)
  VmSetRegister(/*ARGUMENT*/(2))
  VmPop(1)
/* Set(aResult,1.0)  */
/* number : 1.0  */
  VmPushConstant(14)
  VmSetRegister(/*ARGUMENT*/(3))
  VmPop(1)
/* Set(term,1.0)  */
/* number : 1.0  */
  VmPushConstant(14)
  VmSetRegister(/*ARGUMENT*/(4))
  VmPop(1)
/* Set(eps,MathIntPower(10,MathNegate(GetPrecision())))  */
  VmPushNulls(1)
/* number : 10  */
  VmPushConstant(13)
  VmPushNulls(1)
  VmPushNulls(1)
  VmCall(LispGetPrecision, 0 )
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
  VmCall(Compiled_MathIntPower, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(5))
  VmPop(1)
/* While (GreaterThan(MathAbs(term),eps) ) */
VmLabel(C44 )
  VmPushNulls(1)
  VmPushNulls(1)
/* local : term  */
  VmPush(/*ARGUMENT*/(4))
  VmCall(LispAbs, 1 )
  VmPop(1 )
/* local : eps  */
  VmPush(/*ARGUMENT*/(5))
  VmCall(LispGreaterThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C45 )
/* Set(i,MathAdd(i,1))  */
  VmPushNulls(1)
/* local : i  */
  VmPush(/*ARGUMENT*/(2))
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(2))
  VmPop(1)
/* Set(term,MathDivide(MathMultiply(term,x),i))  */
  VmPushNulls(1)
  VmPushNulls(1)
/* local : term  */
  VmPush(/*ARGUMENT*/(4))
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispMultiply, 2 )
  VmPop(2 )
/* local : i  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(LispDivide, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(4))
  VmPop(1)
/* Set(aResult,MathAdd(aResult,term))  */
  VmPushNulls(1)
/* local : aResult  */
  VmPush(/*ARGUMENT*/(3))
/* local : term  */
  VmPush(/*ARGUMENT*/(4))
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(3))
  VmPop(2)
  VmJump(C44 )
VmLabel(C45 )
  VmPop(1)
/* local : aResult  */
  VmPush(/*ARGUMENT*/(3))
  VmSetRegister(0/*RESULT*/)
  VmPop(5 )
VmFunctionEnd() /* (9*BitsPerLong)/8+148  bytes in byte code mode. */


VmFunction(MathExpDoubling)
  VmPushNulls(2 )
/* Local(shift,result)  */
  VmInitRegister(/*ARGUMENT*/(3 ), 23)
  VmInitRegister(/*ARGUMENT*/(4 ), 0)
  VmPushConstant(2)
  VmPop(1)
/* Set(shift,n)  */
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
  VmSetRegister(/*ARGUMENT*/(3))
  VmPop(1)
/* Set(result,value)  */
/* local : value  */
  VmPush(/*ARGUMENT*/(1))
  VmSetRegister(/*ARGUMENT*/(4))
  VmPop(1)
/* While (GreaterThan(shift,0) ) */
VmLabel(C46 )
  VmPushNulls(1)
/* local : shift  */
  VmPush(/*ARGUMENT*/(3))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispGreaterThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C47 )
/* Set(result,MathMultiply(result,result))  */
  VmPushNulls(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(4))
/* local : result  */
  VmPush(/*ARGUMENT*/(4))
  VmCall(LispMultiply, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(4))
  VmPop(1)
/* Set(shift,MathAdd(shift,MathNegate(1)))  */
  VmPushNulls(1)
/* local : shift  */
  VmPush(/*ARGUMENT*/(3))
  VmPushNulls(1)
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
  VmCall(LispAdd, 2 )
  VmPop(2 )
  VmSetRegister(/*ARGUMENT*/(3))
  VmPop(2)
  VmJump(C46 )
VmLabel(C47 )
  VmPop(1)
/* local : result  */
  VmPush(/*ARGUMENT*/(4))
  VmSetRegister(0/*RESULT*/)
  VmPop(3 )
VmFunctionEnd() /* (4*BitsPerLong)/8+87  bytes in byte code mode. */


VmFunction(MathMul2Exp)
/* If (GreaterThan(n,0) ) MathMultiply(x,MathIntPower(2,n))  */
/* else MathDivide(x,MathIntPower(2,MathNegate(n)))  */
  VmPushNulls(1)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispGreaterThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C48 )
  VmPop(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmPushNulls(1)
/* number : 2  */
  VmPushConstant(12)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(Compiled_MathIntPower, 2 )
  VmPop(2 )
  VmCall(LispMultiply, 2 )
  VmPop(2 )
  VmJump(C49 )
VmLabel(C48 )
  VmPop(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmPushNulls(1)
/* number : 2  */
  VmPushConstant(12)
  VmPushNulls(1)
/* local : n  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
  VmCall(Compiled_MathIntPower, 2 )
  VmPop(2 )
  VmCall(LispDivide, 2 )
  VmPop(2 )
VmLabel(C49 )
  VmSetRegister(0/*RESULT*/)
  VmPop(1 )
VmFunctionEnd() /* (6*BitsPerLong)/8+69  bytes in byte code mode. */


VmFunction(MathExp)
/* If (Equals(x,0) ) 1  */
/* else If(LessThan(x,0),MathDivide(1,MathExp(MathNegate(x))),If(GreaterThan(x,1),MathExpDoubling(MathExpTaylor0(MathMul2Exp(x,MathNegate(MathBitCount(x)))),MathBitCount(x)),MathExpTaylor0(x)))  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispEquals, 2 )
  VmPop(2 )
  VmJumpIfFalse(C50 )
  VmPop(1)
/* number : 1  */
  VmPushConstant(5)
  VmJump(C51 )
VmLabel(C50 )
  VmPop(1)
/* If (LessThan(x,0) ) MathDivide(1,MathExp(MathNegate(x)))  */
/* else If(GreaterThan(x,1),MathExpDoubling(MathExpTaylor0(MathMul2Exp(x,MathNegate(MathBitCount(x)))),MathBitCount(x)),MathExpTaylor0(x))  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispLessThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C52 )
  VmPop(1)
  VmPushNulls(1)
/* number : 1  */
  VmPushConstant(5)
  VmPushNulls(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
  VmCall(Compiled_MathExp, 1 )
  VmPop(1 )
  VmCall(LispDivide, 2 )
  VmPop(2 )
  VmJump(C53 )
VmLabel(C52 )
  VmPop(1)
/* If (GreaterThan(x,1) ) MathExpDoubling(MathExpTaylor0(MathMul2Exp(x,MathNegate(MathBitCount(x)))),MathBitCount(x))  */
/* else MathExpTaylor0(x)  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispGreaterThan, 2 )
  VmPop(2 )
  VmJumpIfFalse(C54 )
  VmPop(1)
  VmPushNulls(1)
  VmPushNulls(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmPushNulls(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispBitCount, 1 )
  VmPop(1 )
  VmCall(LispMathNegate, 1 )
  VmPop(1 )
  VmCall(Compiled_MathMul2Exp, 2 )
  VmPop(2 )
  VmCall(Compiled_MathExpTaylor0, 1 )
  VmPop(1 )
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(LispBitCount, 1 )
  VmPop(1 )
  VmCall(Compiled_MathExpDoubling, 2 )
  VmPop(2 )
  VmJump(C55 )
VmLabel(C54 )
  VmPop(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
  VmCall(Compiled_MathExpTaylor0, 1 )
  VmPop(1 )
VmLabel(C55 )
VmLabel(C53 )
VmLabel(C51 )
  VmSetRegister(0/*RESULT*/)
  VmPop(1 )
VmFunctionEnd() /* (13*BitsPerLong)/8+143  bytes in byte code mode. */


VmFunction(MathPower)
/* If (Equals(x,0) ) 0  */
/* else If(Equals(x,1),1,If(IsInteger(y),MathIntPower(x,y),False))  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 0  */
  VmPushConstant(3)
  VmCall(LispEquals, 2 )
  VmPop(2 )
  VmJumpIfFalse(C56 )
  VmPop(1)
/* number : 0  */
  VmPushConstant(3)
  VmJump(C57 )
VmLabel(C56 )
  VmPop(1)
/* If (Equals(x,1) ) 1  */
/* else If(IsInteger(y),MathIntPower(x,y),False)  */
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* number : 1  */
  VmPushConstant(5)
  VmCall(LispEquals, 2 )
  VmPop(2 )
  VmJumpIfFalse(C58 )
  VmPop(1)
/* number : 1  */
  VmPushConstant(5)
  VmJump(C59 )
VmLabel(C58 )
  VmPop(1)
/* If (IsInteger(y) ) MathIntPower(x,y)  */
/* else False  */
  VmPushNulls(1)
/* local : y  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(LispIsInteger, 1 )
  VmPop(1 )
  VmJumpIfFalse(C60 )
  VmPop(1)
  VmPushNulls(1)
/* local : x  */
  VmPush(/*ARGUMENT*/(1))
/* local : y  */
  VmPush(/*ARGUMENT*/(2))
  VmCall(Compiled_MathIntPower, 2 )
  VmPop(2 )
  VmJump(C61 )
VmLabel(C60 )
  VmPop(1)
/* atom : False  */
  VmPushConstant(4)
VmLabel(C61 )
VmLabel(C59 )
VmLabel(C57 )
  VmSetRegister(0/*RESULT*/)
  VmPop(1 )
VmFunctionEnd() /* (4*BitsPerLong)/8+83  bytes in byte code mode. */






class Plugin_libmath : public LispPluginBase
{
public:
    virtual void Add(LispEnvironment& aEnvironment);
    virtual void Remove(LispEnvironment& aEnvironment);
};

void Plugin_libmath::Add(LispEnvironment& aEnvironment)
{

CONSTANTS[23] = ATOM("shift");
CONSTANTS[23]->IncreaseRefCount();
CONSTANTS[22] = ATOM("term");
CONSTANTS[22]->IncreaseRefCount();
CONSTANTS[21] = ATOM("aResult");
CONSTANTS[21]->IncreaseRefCount();
CONSTANTS[20] = ATOM("i");
CONSTANTS[20]->IncreaseRefCount();
CONSTANTS[19] = ATOM("c");
CONSTANTS[19]->IncreaseRefCount();
CONSTANTS[18] = ATOM("s");
CONSTANTS[18]->IncreaseRefCount();
CONSTANTS[17] = ATOM("q");
CONSTANTS[17]->IncreaseRefCount();
CONSTANTS[16] = ATOM("x");
CONSTANTS[16]->IncreaseRefCount();
CONSTANTS[15] = ATOM("0.0");
CONSTANTS[15]->IncreaseRefCount();
CONSTANTS[14] = ATOM("1.0");
CONSTANTS[14]->IncreaseRefCount();
CONSTANTS[13] = ATOM("10");
CONSTANTS[13]->IncreaseRefCount();
CONSTANTS[12] = ATOM("2");
CONSTANTS[12]->IncreaseRefCount();
CONSTANTS[11] = ATOM("newPrec");
CONSTANTS[11]->IncreaseRefCount();
CONSTANTS[10] = ATOM("previousPrec");
CONSTANTS[10]->IncreaseRefCount();
CONSTANTS[9] = ATOM("eps");
CONSTANTS[9]->IncreaseRefCount();
CONSTANTS[8] = ATOM("orig");
CONSTANTS[8]->IncreaseRefCount();
CONSTANTS[7] = ATOM("x2");
CONSTANTS[7]->IncreaseRefCount();
CONSTANTS[6] = ATOM("0.");
CONSTANTS[6]->IncreaseRefCount();
CONSTANTS[5] = ATOM("1");
CONSTANTS[5]->IncreaseRefCount();
CONSTANTS[4] = ATOM("False");
CONSTANTS[4]->IncreaseRefCount();
CONSTANTS[3] = ATOM("0");
CONSTANTS[3]->IncreaseRefCount();
CONSTANTS[2] = ATOM("True");
CONSTANTS[2]->IncreaseRefCount();
CONSTANTS[1] = ATOM("unit");
CONSTANTS[1]->IncreaseRefCount();
CONSTANTS[0] = ATOM("result");
CONSTANTS[0]->IncreaseRefCount();


  aEnvironment.SetCommand(Compiled_MathPower,"MathPower",2 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathExp,"MathExp",1 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathMul2Exp,"MathMul2Exp",2 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathExpDoubling,"MathExpDoubling",2 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathExpTaylor0,"MathExpTaylor0",1 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathArcSin,"MathArcSin",1 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathTan,"MathTan",1 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathCos,"MathCos",1 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathSin,"MathSin",1 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_Trigonometry,"Trigonometry",4 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_MathIntPower,"MathIntPower",2 ,YacasEvaluator::Function | YacasEvaluator::Fixed);
  aEnvironment.SetCommand(Compiled_PositiveIntPower,"PositiveIntPower",2 ,YacasEvaluator::Function | YacasEvaluator::Fixed);

}
void Plugin_libmath::Remove(LispEnvironment& aEnvironment)
{
if (!CONSTANTS[23]->DecreaseRefCount()) delete CONSTANTS[23];
if (!CONSTANTS[22]->DecreaseRefCount()) delete CONSTANTS[22];
if (!CONSTANTS[21]->DecreaseRefCount()) delete CONSTANTS[21];
if (!CONSTANTS[20]->DecreaseRefCount()) delete CONSTANTS[20];
if (!CONSTANTS[19]->DecreaseRefCount()) delete CONSTANTS[19];
if (!CONSTANTS[18]->DecreaseRefCount()) delete CONSTANTS[18];
if (!CONSTANTS[17]->DecreaseRefCount()) delete CONSTANTS[17];
if (!CONSTANTS[16]->DecreaseRefCount()) delete CONSTANTS[16];
if (!CONSTANTS[15]->DecreaseRefCount()) delete CONSTANTS[15];
if (!CONSTANTS[14]->DecreaseRefCount()) delete CONSTANTS[14];
if (!CONSTANTS[13]->DecreaseRefCount()) delete CONSTANTS[13];
if (!CONSTANTS[12]->DecreaseRefCount()) delete CONSTANTS[12];
if (!CONSTANTS[11]->DecreaseRefCount()) delete CONSTANTS[11];
if (!CONSTANTS[10]->DecreaseRefCount()) delete CONSTANTS[10];
if (!CONSTANTS[9]->DecreaseRefCount()) delete CONSTANTS[9];
if (!CONSTANTS[8]->DecreaseRefCount()) delete CONSTANTS[8];
if (!CONSTANTS[7]->DecreaseRefCount()) delete CONSTANTS[7];
if (!CONSTANTS[6]->DecreaseRefCount()) delete CONSTANTS[6];
if (!CONSTANTS[5]->DecreaseRefCount()) delete CONSTANTS[5];
if (!CONSTANTS[4]->DecreaseRefCount()) delete CONSTANTS[4];
if (!CONSTANTS[3]->DecreaseRefCount()) delete CONSTANTS[3];
if (!CONSTANTS[2]->DecreaseRefCount()) delete CONSTANTS[2];
if (!CONSTANTS[1]->DecreaseRefCount()) delete CONSTANTS[1];
if (!CONSTANTS[0]->DecreaseRefCount()) delete CONSTANTS[0];


aEnvironment.RemoveCoreCommand("MathPower");
aEnvironment.RemoveCoreCommand("MathExp");
aEnvironment.RemoveCoreCommand("MathMul2Exp");
aEnvironment.RemoveCoreCommand("MathExpDoubling");
aEnvironment.RemoveCoreCommand("MathExpTaylor0");
aEnvironment.RemoveCoreCommand("MathArcSin");
aEnvironment.RemoveCoreCommand("MathTan");
aEnvironment.RemoveCoreCommand("MathCos");
aEnvironment.RemoveCoreCommand("MathSin");
aEnvironment.RemoveCoreCommand("Trigonometry");
aEnvironment.RemoveCoreCommand("MathIntPower");
aEnvironment.RemoveCoreCommand("PositiveIntPower");

}

extern "C" {
//#ifdef EXE_DLL_PLUGINS
LispPluginBase* make_libmath(void);
//#else
//LispPluginBase* maker(void);
//#endif
};
//#ifdef EXE_DLL_PLUGINS
LispPluginBase* make_libmath(void)
//#else
//LispPluginBase* maker(void)
//#endif
{
    return NEW Plugin_libmath;
}





