/* :: ascii-jump project
   :: $Id: scrtraing.c,v 1.1.1.1 2003/02/28 10:05:04 loth Exp $
   
   :: copyright (c) 2003 :: grzegorz moskal, g.moskal@opengruop.org
   :: license gnu gpl v 2						*/

#define SCRTRAIN_C
#include "scrtrain.h"

struct object *jumper;
static struct widget* scr_train;
static struct widget* win_train;
static struct widget* menu_train;

void scrtrain_show()
{
	screen = scr_train;
	status = MENU;
	sl_cls();
}

static void scrtrain_playhill(void)
{
	char *title = menu_selected_caption(menu_train);
	struct hill *map = hill_find(hills, title);
	
	jumper_flush(jumper, map);
	hill_intro(map);
	
	game_show();
}

static void scrtrain_init()
{
	struct hill *h = hills;
	int uw = WIDTH/10;
	int uh = HEIGHT/10;
	scr_train = screen_add();
	win_train = window_add(scr_train, "select _h_i_l_l",
		uw*3, 1, uw*4, uh*10-1);
	menu_train = menu_add(win_train, 1, 2, uw*4-2, uh*10-3, 0);
	for (; h; SWITCH(h))
		menuobj_add(menu_train, h->name,
			h->name[d(strlen(h->name))-1], scrtrain_playhill, 0);
	menuobj_add(menu_train, "<<<",'<', scrmain_show, OBJ_DOWN);
}

void train_init()
{
	jumper = jumper_init(hills, skin, "foo");
	jumper_change_mode(jumper, NULL, Blue, 0, 1);
	scrtrain_init();
}
