#ifndef __nfa_h__
#define __nfa_h__


#include <limits.h>
#include <stdio.h>
#include "dfa.h"
#include "set.h"


/** NFA state. */
typedef struct {
	/** Symbols that label the edges out of this state. */
	char symbols[CHAR_MAX];

	/** States that follow this state. */
	Set followpos;
	
	/** Token associated with this state. */
	int token;
} State;


/** Non-finite discrete automoton. */
typedef struct {
	/** Initial states. */
	Set firstpos;

	/** Final states. */
	Set lastpos;

	/** Number of states. */
	int count;

	/** States. */
	State states[STATES];
} NFA;


#define clear_nfa(nfa) memset( nfa, 0, sizeof *nfa)

void print_nfa( const NFA* nfa);
void read_nfa( NFA* nfa, FILE* file);
void compile_nfa( DFA* dfa, const NFA* nfa);


#endif
