/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PC__
#define __PC__

#include <gtk/gtk.h>

typedef struct _pc_win pc_win;
typedef GtkTable       pc_sec;
typedef GtkWidget      pc_var;

typedef void (* pc_func)       (void *data);
typedef int  (* pc_apply_func) (void *data);
typedef void (* pc_help_func)  (int section,
				const char *sectionname,
				void *data);

/* Standard operations */
pc_win *pc_new    (const char    *name,
		   pc_apply_func  apply_cb,
		   pc_func        close_cb,
		   pc_help_func   help_cb,
		   int            show_apply,
		   const void    *data);
void    pc_show   (pc_win *win);
void    pc_hide   (pc_win *win);
void    pc_destroy(pc_win *win);
void    pc_modal  (pc_win *win, int on);

/* Adding sections */
pc_sec *pc_section_new   (pc_win *win,
			  const char *desc);
pc_sec *pc_subsection_new(pc_sec *sec,
			  const char *desc);

/* Adding variables */
pc_var *pc_radio_new(pc_sec *sec,
		     pc_var *radio,
		     const char *desc,
		     int *variable);
pc_var *pc_option_new(pc_sec    *sec,
		      const char *desc,
		      int         *variable,
		      ...); /* add strings here ... NULL terminated*/
pc_var *pc_check_new (pc_sec    *sec,
		      const char  *desc,
		      int         *variable);
pc_var *pc_spin_new  (pc_sec    *sec,
		      const char  *desc,
		      int          lower,
		      int          upper,
		      int         *variable);
pc_var *pc_entry_new (pc_sec    *sec,
		      const char  *desc,
		      char       **variable);
pc_var *pc_font_new  (pc_sec    *sec,
		      const char  *desc,
		      char       **variable);
pc_var *pc_scale_new (pc_sec    *sec,
		      const char  *desc,
		      int         show_int_val,
		      int         show_hex_val,
		      int lower,
		      int upper,
		      int        *variable);
pc_var *pc_file_new  (pc_sec    *sec,
		      const char  *desc,
		      char       **variable);

/* Locking, can be only used with check variables */
void pc_check_lock          (pc_var  *check,
			     ...); /* add pc_var*s here ... NULL terminated*/
void pc_check_lock_reversed (pc_var  *check,
			     ...); /* add pc_var*s here ... NULL terminated*/
void pc_check_lock2         (pc_var  *check0,
			     pc_var  *check1,
			     ...); /* add pc_var*s here ... NULL terminated*/
void pc_check_lock_through  (pc_var  *check0,
			     ...);

struct _pc_win {
    GtkWidget *window;
    GtkWidget *ctree;
    GtkWidget *notebook;
    GtkWidget *ok;
    GtkWidget *apply;
    GtkWidget *close;
    GtkWidget *help;
    pc_apply_func apply_cb;
    pc_func       close_cb;
    pc_help_func  help_cb;
    const void   *data;
    GSList *section_names;
    GSList *section_nodes;
};


#endif /* __PC__ */
