/* Definitions for hosting on WIN32, for GDB.
   Copyright 1995, 1996, 1997, 1998, 2001 Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include "fopen-bin.h"

#define SLASH_P(X) ((X)=='\\' || (X) == '/')
#define ROOTED_P(X) ((SLASH_P((X)[0]))|| ((X)[1] ==':'))
#define SLASH_CHAR '/'
#define SLASH_STRING "/"

extern const char *cygwin_to_host_dir_spec (const char *dir);
#define TO_HOST_DIR_SPEC(DIRSPEC) (cygwin_to_host_dir_spec (DIRSPEC))

extern const char *cygwin_to_host_file_spec (const char *filename);
#define TO_HOST_FILE_SPEC(FILESPEC)(cygwin_to_host_file_spec (FILESPEC))

extern const char *cygwin_to_normal_dir_spec (const char *dir);
#define TO_NORMAL_DIR_SPEC(DIRSPEC) (cygwin_to_normal_dir_spec (DIRSPEC))

extern const char *cygwin_to_normal_file_spec (const char *filename);
#define TO_NORMAL_FILE_SPEC(FILESPEC)(cygwin_to_normal_file_spec (FILESPEC))

extern const char *cygwin_to_host_path_spec (const char *path);
#define TO_HOST_PATH_SPEC(PATHSPEC)(cygwin_to_host_path_spec (PATHSPEC))

/* Define this if source files use \r\n rather than just \n.  */
#define CRLF_SOURCE_FILES
