#include <string.h>
#include <descrip.h>
#include <starlet.h>
#include <ssdef.h>
#include <stdio.h>
#include <unistd.h>
#include <secdef.h>
#include <va_rangedef.h>

static char _align (page) gdbstub_command_line[1024];

unsigned long int
gdbstub_get_foreign
  (struct dsc$descriptor_s *resultant_string,
   struct dsc$descriptor_s *prompt_string,
   unsigned short int *resultant_length,
   unsigned long int *flags)
{
  struct dsc$descriptor_s gdbstub_psc;
  char pscbuff[16];
  int mypid = getpid ();
  long status;
  va_range gdbstub_command_line_inadr =
    {&gdbstub_command_line [0], &gdbstub_command_line [1023]};
  va_range gdbstub_command_line_retadr;

  sprintf (pscbuff, "gdbstub%x", mypid);
  gdbstub_psc.dsc$w_length = strlen (pscbuff);
  gdbstub_psc.dsc$b_dtype = DSC$K_DTYPE_T;
  gdbstub_psc.dsc$b_class = DSC$K_CLASS_S;
  gdbstub_psc.dsc$a_pointer = pscbuff;

  status = sys$crmpsc
    (&gdbstub_command_line_inadr,  /* inadr */
     &gdbstub_command_line_retadr, /* retadr */
     0,                            /* acmode */
     SEC$M_GBL | SEC$M_EXPREG | SEC$M_PAGFIL,     /* flags */
     &gdbstub_psc,                 /* gsdnam */
     0,                            /* ident */
     0,                            /* relpag */
     0,                            /* chan */
     1,                            /* pagcnt */
     0,                            /* vbn */
     0,                            /* prot */
     0                             /* pfc */
     );

#if 0
  printf ("gdbstub_get_foreign retadr: %x - %x\n",
	  gdbstub_command_line_retadr.va_range$ps_start_va,
	  gdbstub_command_line_retadr.va_range$ps_end_va);
#endif

  strcpy (resultant_string->dsc$a_pointer,
	  (char *) gdbstub_command_line_retadr.va_range$ps_start_va);
  *resultant_length
    = strlen ((char *) gdbstub_command_line_retadr.va_range$ps_start_va);

#if 0
  printf ("evax_get_foreign: '%s'\n", resultant_string->dsc$a_pointer);
#endif

  return SS$_NORMAL;
}

