/**
 ** help_window.c - display the help file
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"

static GtkWidget *help_window = NULL;

void create_help_window()
{
    GladeXML *xml;
    GtkWidget *less;

    if( help_window )
	return;

    /* load the main_window decsription */
    xml = glade_xml_new( gnomp3.glade_file, "help_window");
    if(!xml){
	xml = glade_xml_new( "gnomp3.glade", "help_window");
    }
    /* in case we can't load the interface, bail */
    if(!xml) {
	g_warning("We could not load the main_window interface!");
	return;
    }

    /* autoconnect any signals */
    glade_xml_signal_autoconnect(xml);
    
    help_window = glade_xml_get_widget( xml, "help_window");
    less =  glade_xml_get_widget( xml, "help_less");

    /* we don't need the GladeXML object any more, so unref it
       to save some memory */
    gtk_object_unref(GTK_OBJECT(xml));

    if( !gnome_less_show_file( GNOME_LESS(less), "/usr/share/gnomp3/README.help" )){
	gnome_less_show_file( GNOME_LESS(less), "README.help" );
    }
}

void help_window_destroy(GtkWidget *w, gpointer data)
{
    gtk_widget_destroy(help_window);
    help_window = NULL;
}
