/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GTKUTILS_H__
#define __GTKUTILS_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

void   gtkutil_menu_position_under_widget	(GtkMenu *menu,
						 gint *x, gint *y,
						 gboolean *push_in,
						 gpointer user_data);

void   gtkutil_copy_text                        (const gchar *text);
void   gtkutil_append_im_menuitem               (GtkMenuShell *shell);

void   gtkutil_superpose_pixbuf                 (GtkWidget *widget,
						 GdkPixbuf *pixbuf, 
						 const gchar *stock_id,
						 GtkIconSize size);

gboolean gtkutil_confirm_file_replace           (GtkWindow *parent,
						 const gchar *filename);

#define GTKUTIL_CREATE_MENU(combo, array, n_array, field)              \
{								       \
	guint i;                                                       \
								       \
	for (i = 0; i < (guint) n_array; i++)			       \
	{                                                              \
		gtk_combo_box_append_text(GTK_COMBO_BOX(combo),        \
					  _(array[i].field));          \
	}                                                              \
}


#define GTKUTIL_SET_DEFAULT_HISTORY(menu, str, array, n_array, field)	       \
{									       \
	guint i;							       \
									       \
	gtk_combo_box_set_active(GTK_COMBO_BOX(menu), 0);	               \
	for (i = 0; str && i < (guint) n_array; i++)			       \
	{								       \
		if (!strcmp(str, array[i].field))			       \
		{							       \
			gtk_combo_box_set_active(GTK_COMBO_BOX(menu), i);      \
			break;						       \
		}							       \
	}								       \
}

#if (GTK_MAJOR_VERSION == 2) && (GTK_MINOR_VERSION < 5)
typedef enum {
        GDK_PIXBUF_ROTATE_NONE             =   0,
        GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE =  90,
        GDK_PIXBUF_ROTATE_UPSIDEDOWN       = 180,
        GDK_PIXBUF_ROTATE_CLOCKWISE        = 270
} GdkPixbufRotation;
				
/* this function is taken from GTK+-2.5.x */
GdkPixbuf *gdk_pixbuf_rotate_simple (const GdkPixbuf *src,
				     GdkPixbufRotation angle);
#endif

G_END_DECLS

#endif /* __GTKUTILS_H__ */
