/**
 * a class that processes incoming connections to 
 * get info on them and work out the type of connection that they are.
 */

#include "ezthread.h"
#include "songinfo.h"

class IncomingConnection : public EZThread
{
public:
   typedef enum 
   { 
      CONNECTION_UNKNOWN,CONNECTION_TIMEDOUT,
      CONNECTION_DOWNLOAD,CONNECTION_UPLOAD,
      CONNECTION_INVALID
   } ConnectionType;
   
   IncomingConnection(int sock);
   virtual ~IncomingConnection();

   ConnectionType getType();
   
   virtual void run_method();

   // detachTransferload(); ???
   //
   int getSocket() { return sock; }
   SongInfo getSongInfo() { return songinfo; }
private:
   ConnectionType type;
   int sock;
   SongInfo songinfo;
};
