#ifndef KNAP_CHANPANEL_H
#define KNAP_CHANPANEL_H

#include <qframe.h>
#include <qstringlist.h>

class QLabel;
class KTextBrowser;
class KNAP_ListView;
class QLineEdit;
class QListViewItem;
class QListView;
class QPopupMenu;

class KNAP_ChanPanel
: public QFrame
{
   Q_OBJECT
   
signals:
   void sendcommand(const char *comm); 
public slots:
   void clear();
   //void clearUserlist();
private slots:
   void calcCommand();
   void closePressed();

   void popupKill();

   void popupMessage();
   void popupPing();
   void popupWhois();

   void popupIgnore();
   void popupUnignore(); 

   void popupAddHotlist();

   void popupMenu( QListViewItem *, const QPoint &, int );

   public:
   KNAP_ChanPanel(QWidget *parent=0,const char *name=0);
   virtual ~KNAP_ChanPanel();
   public:
   typedef enum MessageType 
   { 
      MessageNone, MessageNormal, MessageMessage, 
      MessageNotify, MessageError 
   };

   void writeString(QString &str,MessageType m = MessageNone);
   void writeString(const char *str,MessageType m = MessageNone);

   void addUser(QString userdata,bool notify=false);
   void remUser(QString userdata);

   void setOffline();
   // void setTopic(QString text);
   void addUserMessage(QString userdata);
   void addUserActionMessage(QString data);

   void setWhoAmI(const QString me) { whoami = me; }
   void setEchoMode(bool yes) { echo = yes; }

   void setTopic(const QString &t); 

   void showUserlist(bool yes); // the console and IM window is just
   // this window with userlist hidden
   bool isUserlistShown();
   private:
   bool firstline;
   bool echo;

   QString whoami;
   QLabel *topic;
   KTextBrowser *chantext;
   KNAP_ListView *users;
   QLineEdit *command;


   QPopupMenu *popupmenu;

   // void showExtendedMenus(bool yes);

   QStringList badwords;

   QString &fixString(QString &str);

   QString &filterLanguage(QString &str);

   QString getFontString(MessageType m);

   void runCommand(QListView *view,const QString &comm);
};

#endif // KNAP_CHANPANEL_H
