/*
 *  Copyright (c) 2000 Jason Petrone <jp@demonseed.net>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 */

#include "data.h"
#include "config.h"

#include "support.h"
#include "interface.h"

#include <gnome.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>

gchar *confpath = NULL;

extern AppData *ad;
extern GtkWidget *inlabel, *outlabel, *frame;
extern gint netmon_draw(void);
extern guint timeout_handle;

GtkWidget *propwin, *fontwin;

GtkWidget *dlg; /* XXX: DELETE ME! */

extern void init_ui();

static void errdlg(const char *msg){
  dlg = gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
                               GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, msg);
                              
  gtk_dialog_run (GTK_DIALOG (dlg));
  gtk_widget_destroy (dlg);
}

void property_load(PanelApplet *applet, AppData *ad) {
  gchar *s;

  s = (char*)panel_applet_gconf_get_string(applet, "interface", NULL);
  if (!s) s = DEFAULT_INTERFACE;
  ad->interface = malloc(strlen(s) + 1);
  strcpy(ad->interface, s);

  s = panel_applet_gconf_get_string(applet, "font", NULL);

  if (!s) s = "Sans 10";
  ad->font = malloc(strlen(s) + 1);
  strcpy(ad->font, s);

  ad->layout = panel_applet_gconf_get_bool(applet, "vertical_layout", NULL);
  ad->show_frame = panel_applet_gconf_get_bool(applet, "show_border", NULL);
  return;
}

gint property_save(PanelApplet *applet){
  panel_applet_gconf_set_string(applet, "interface", ad->interface, NULL);
  panel_applet_gconf_set_string(applet, "font", ad->font, NULL);
  panel_applet_gconf_set_bool(applet, "vertical_layout", 
                                 ad->layout == NETMON_LAYOUT_VERTICAL, NULL);
  panel_applet_gconf_set_bool(applet, "show_border", ad->show_frame, NULL);

  return 0;
}

void property_apply_cb(GtkWidget *widget, void *nodata, gpointer data) {
  PangoFontDescription *font_desc;
  char buf[1024];
  GtkWidget *btn, *iface;

  iface = lookup_widget(propwin, "interface_entry");
  if (ad->interface) free(ad->interface);
  ad->interface = malloc(strlen(gtk_entry_get_text(GTK_ENTRY(iface))) + 1);
  strcpy(ad->interface, gtk_entry_get_text(GTK_ENTRY(iface)));

  btn = lookup_widget(propwin, "font_button");
  if (ad->font) free(ad->font);
  ad->font = malloc(strlen(gtk_button_get_label(GTK_BUTTON(btn)))+1);
  strcpy(ad->font, gtk_button_get_label(GTK_BUTTON(btn)));

  btn = lookup_widget(propwin, "show_borderbtn");
  ad->show_frame = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn));

  btn = lookup_widget(propwin, "horizbtn");
  ad->layout = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn)) 
                  ? NETMON_LAYOUT_HORIZONTAL : NETMON_LAYOUT_VERTICAL;
                  
  property_save(ad->applet);

  init_ui();
}


gint property_choose_font(GtkWidget *widget, gpointer data) {
  GtkWidget *fontsel, *btn;
  const char *font;
  fontwin = create_fontwin();
  fontsel = lookup_widget(fontwin, "fontsel");
  btn = lookup_widget(propwin, "font_button");
  font = gtk_button_get_label(GTK_BUTTON(btn));
  gtk_font_selection_set_font_name(GTK_FONT_SELECTION(fontsel), font);
  gtk_widget_show(fontwin);

  return 0;
}

gint property_set_font(GtkWidget *fontsel, gpointer data) {
  char *font = gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel));
  GtkWidget *btn = lookup_widget(propwin, "font_button");
  gtk_button_set_label(GTK_BUTTON(btn), font);
  gtk_widget_destroy(fontwin);
  /* gtk_widget_hide(fontwin); */
  fontwin = NULL;

  return 0;
}

gint property_close_cb(GtkWidget *widget, gpointer data) {
  if (fontwin) gtk_widget_destroy(fontwin);
  fontwin = NULL;
  gtk_widget_destroy(propwin);
  propwin = NULL;

  if (initialize(ad->interface, 5) < 0){
    fprintf(stderr, "Cannot init %s!\n", ad->interface);
  }
  time(&starttime);
  timeout_handle = gtk_timeout_add(UPDATE_TIMEOUT, (void *)netmon_draw, NULL);

  gtk_frame_set_label(GTK_FRAME(frame), ad->interface);
  return 0;
}

gint property_ok_cb(GtkDialog *widget, gint resp, gpointer data) {
  property_apply_cb(GTK_WIDGET(propwin), NULL, data);
  property_close_cb(GTK_WIDGET(widget), data);
  return 0;
}


void property_show(BonoboUIComponent *ui, gpointer data, const char *cname){
  GtkWidget *w;

  gtk_timeout_remove(timeout_handle);
  timeout_handle = -1;

  propwin = create_propwin();
  if (ad->layout == NETMON_LAYOUT_HORIZONTAL){
    w = lookup_widget(propwin, "horizbtn");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
  }
  else {
    w = lookup_widget(propwin, "vertbtn");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
  }

  if (ad->show_frame){
    w = lookup_widget(propwin, "show_borderbtn");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
  }
  else {
    w = lookup_widget(propwin, "noshow_borderbtn");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
  }
  /* gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), ad->show_frame); */

  w = lookup_widget(propwin, "font_button");
  gtk_button_set_label(GTK_BUTTON(w), ad->font);

  w = lookup_widget(propwin, "interface_entry");
  gtk_entry_set_text(GTK_ENTRY(w), ad->interface);
  
  gtk_widget_show(propwin);
}
