#if LINUX_VERSION_CODE > 0x020100
# include <asm/types.h>
# if  __GLIBC_MINOR__ < 1
#  include <linux/in6.h>
# endif
#endif

/* for csum_and_copy_to_user() in checksum.h */
#if LINUX_VERSION_CODE > 0x020177
# include <errno.h>
# define	VERIFY_WRITE	1
# if LINUX_VERSION_CODE > 0x020200
#  undef	asmlinkage
#  define	asmlinkage
# endif
#endif

#include <asm/checksum.h>

#define	GET_U32(ptr)	(*(u_int32_t *)(ptr))
#define	GET_U16(ptr)	(*(u_int16_t *)(ptr))

#define	PUT_U32(ptr,val)	(*(u_int32_t *)ptr = val)
#define	PUT_U16(ptr,val)	(*(u_int16_t *)ptr = val)

#define	IP_CALC_CSUM(ip)	ip_fast_csum((u_char *)ip, ip->ip_hl)
