#
#
#
#

set conf_selected ""

proc conf:select {lbox offset} {
    global conf_selected

    foreach i [$lbox curselection] {
	set s [$lbox get [expr $i + $offset]]
	if {$s != ""} {
	    set conf_selected $s
	}
    }
}

proc conf:finish_select {window} {
    destroy [winfo toplevel $window]
}

proc conf:cancel_select {window} {
    global conf_selected

    set conf_selected {}
    destroy [winfo toplevel $window]
}

proc conf:file_list {frame label list} {
    option add *filesList.width  12
    option add *filesList.height 10

    frame $frame
    label $frame.label -text $label
    listbox $frame.filesList \
	-xscrollcommand "$frame.scrollbarX set" \
	-yscrollcommand "$frame.scrollbarY set"
    scrollbar $frame.scrollbarX -orient horizontal -takefocus 0 \
	-command "$frame.filesList xview"
    scrollbar $frame.scrollbarY -orient vertical   -takefocus 0 \
	-command "$frame.filesList yview"

    bind $frame.filesList <Button-1>        {focus %W}
    bind $frame.filesList <ButtonRelease-1> {conf:select %W 0}
    bind $frame.filesList <Key-Down>        {conf:select %W 1}
    bind $frame.filesList <Key-Up>          {conf:select %W -1}
    bind $frame.filesList <Double-Button-1> {
	conf:select %W 0
	conf:finish_select %W
    }
    foreach i $list {
	$frame.filesList insert end [file tail $i]
    }
    grid $frame.label      -column 0 -row 0
    grid $frame.filesList  -column 0 -row 1 -sticky nsew
    grid $frame.scrollbarX -column 0 -row 2 -sticky ew
    grid $frame.scrollbarY -column 1 -row 1 -sticky ns
}

proc Conf:SelectDialog {window subdir} {
    option add *SelectDialog*background "\#d9d9d9"
    option add *SelectDialog*foreground "black"
    option add *SelectDialog*font "-*-helvetica-medium-r-normal-*-12-*"
    option add *SelectDialog*Label.font "-*-helvetica-bold-r-normal-*-12-*"

    global PPxP_SysPath PPxP_UsrPath
    global conf_select

    toplevel $window -class SelectDialog
    wm transient $window .

    set syspath [file join $PPxP_SysPath $subdir]
    if [info exists PPxP_UsrPath] {
	set usrpath [file join $PPxP_UsrPath $subdir]
    } else {
	set usrpath ""
    }
    conf:file_list $window.sysDir $syspath \
	[lsort [glob -nocomplain [file join $syspath *]]]
    conf:file_list $window.usrDir $usrpath \
	[lsort [glob -nocomplain [file join $usrpath *]]]

    frame $window.entry
    label $window.entry.fileLabel -text "File:"
    entry $window.entry.fileEntry -width 16 -textvariable conf_selected
    button $window.entry.okButton -text "OK" \
	-command [list conf:finish_select $window]
    button $window.entry.cancelButton -text "Cancel" \
	-command [list conf:cancel_select $window]
    pack $window.entry.fileLabel -side left
    pack $window.entry.fileEntry -side left -fill x -expand yes
    pack $window.entry.cancelButton $window.entry.okButton -side right

    grid $window.sysDir -column 0 -row 0
    grid $window.usrDir -column 1 -row 0
    grid $window.entry  -column 0 -row 1 -columnspan 2 -sticky ew

    wm withdraw $window
    update idletasks
    set x [expr [winfo screenwidth $window]/2 - [winfo reqwidth $window]/2]
    set y [expr [winfo screenheight $window]/2 - [winfo reqheight $window]/2]
    wm geometry $window +$x+$y
    wm title $window "Select Configuration"
    wm deiconify $window

    set oldfocus [focus]
    grab $window
    focus $window.entry.fileEntry

    tkwait window $window

    focus $oldfocus

    global conf_selected
    return $conf_selected
}
