#
#
#
#

Widget:DefineClass CheckBox ButtonBox check:create check:config check_proc

set check_proc(get)	check:get

proc check:create {w a} {
    global check_conf
    set check_conf($w,variable) ""
}

proc check:config {w opt val} {
    switch -- $opt {
	-buttons {
	    check:set_buttons $w $val
	}
	-variable {
	    check:set_variable $w $val
	}
	default {
	    return 1
	}
    }
    return 0
}

proc check:set_buttons {w button_list} {
    global check_var check_val

    set cmd_list {}
    foreach i $button_list {
	set b [lindex $i 0]
	set check_val($w.$b) [lindex $i 1]
	set text [lindex $i 2]

	set cmd "checkbutton $w.$b -variable check_var($w.$b)"
	if {$text != ""} {
	    set cmd "$cmd -text $text"
	}
	lappend cmd_list $cmd
    }
    bbox:config $w -buttons $cmd_list
}

proc check:write_var {w varname} {
    global check_var check_val
    upvar \#0 $varname var

    foreach i [$w subwidget buttons] {
	if {[lsearch -exact $var $check_val($i)] >= 0} {
	    set check_var($i) 1
	} else {
	    set check_var($i) 0
	}
    }
}

proc check:read_var {w varname} {
    upvar \#0 $varname var
    set var [check:get $w {}]
}

proc check:set_variable {w varname} {
    global check_conf

    if {$check_conf($w,variable) != ""} {
	del_trace $check_conf($w,write_var_id)
	del_trace $check_conf($w,read_var_id)
    }
    set check_conf($w,variable) $varname

    catch {
	check:write_var $w $varname
	check:read_var  $w $varname
    }
    set check_conf($w,write_var_id) \
	[Widget:SetTrace $w $varname w [list check:write_var $w $varname]]
    set check_conf($w,read_var_id) \
	[Widget:SetTrace $w $varname r [list check:read_var $w $varname]]
}

proc check:get {w a} {
    global check_var check_val

    set ret {}
    foreach i [$w subwidget buttons] {
	if $check_var($i) {
	    lappend ret $check_val($i)
	}
    }
    return $ret
}

proc check:test {} {
    CheckBox .x1 -buttons {
	{aho	aho	aho}
	{baka	baka	baka}
	{tawake	tawake	tawake}
    } -variable ahoaho
    button .b1 -text Print -command {puts $ahoaho}
    button .b2 -text Reset -command {set ahoaho aho}
    pack .x1 .b1 .b2 -side top -fill x
}
