#define NAME    "xppxp"
#define VERSION "0.00.45"
#define DATE    "9809121300"

#ifndef XPPXPDIR
#define XPPXPDIR "/usr/local/share/ppxp/label"
#endif

#ifndef XtNpolling
#define XtNpolling "polling"
#define XtCPolling "Polling"
#endif 

#ifndef XtNdebug
#define XtNdebug "debug"
#define XtCDebug "Debug"
#endif 

#ifndef XtNlabelName
#define XtNlabelName "labelName"
#define XtCLabelName "LabelName"
#endif

#ifndef XtNdirectory
#define XtNdirectory "directory"
#define XtCDirectory "Directory"
#endif

typedef struct st_AppData
{
        int  polling;
        String  label;
        String  directory;
        Boolean debug;
} AppData, *AppDataPtr;

enum {
    BS_Unchange = -9999,
    BS_False    =     0,
    BS_True     =     1,
};

/* main.c */
extern Widget top, base, panel, indc, tdisp;
extern Widget led1, led2, led3, led4, led5;
extern Widget button1, button2, button3, button4, button5;
extern XtAppContext appc;
extern AppData app_data;
extern char sc_name[32];
extern void FreeAll();
extern void ppxpTry();

/* ppxplink.c */
extern int ppxpFd;
extern XtInputId InputId;
extern int ppxpInit(int *, char **);
extern int ppxpCheck(XtPointer, int*, XtInputId *);
extern int ppxpFinish();
extern int ppxpGetState();
extern char * ppxpGetEnv(char *);

/* panel_init.c */
extern void panel_init();

/* action.c */
extern void NewLabel(char *);
extern void showLeds(int, int, int, int, int, int);
extern void showMeters(int, int);
extern void showConnectTime(int);
extern void AutoButton(Widget, XButtonEvent*);
extern void ConnectButton(Widget, XButtonEvent*);
extern void DisconnectButton(Widget, XButtonEvent*);
extern void ByeButton(Widget, XButtonEvent*);
extern void QuitButton(Widget, XButtonEvent*);
extern void ButtonSet(int, int);
extern void Idling(Widget, XButtonEvent*);
extern void Terminal(Widget, XButtonEvent*);

/* icon.c */
extern Pixmap label_pixmap;
extern void icon_init();
extern void icon_finish();
extern void XpmError();
extern void load_label();
extern void reload_label();

/* signal.c */
extern void signal_init();
