#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <termios.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/types.h>

/*
 * telnet: escape 0x1d, 0xff
 * rlogin:
 */

#include <config.h>
#include <support.h>

#include <option.h>
#include <log.h>
#include "device.h"

#ifndef	XCASE
#define	XCASE	0
#endif

static struct termios oldTio;
static char ptyName[sizeof("/dev/ptyp00")];
static pid_t ptyPid;

static void
PtyClose(int fd)
{
    if (fd >= 0) Close(fd);
}

static bool_t
PtyProbe(char *name)
{
    return(strncasecmp(name, "pty:", 4) ? FALSE: TRUE);
}

static int
PtyOpen(char **devname, int *status, int argc, char *argv[])
{
    int fd;
    char *command, ls, ln;
    struct termios newtio;

    if ((command = strchr(devname[0], '/')) == NULL) {
	*status = OPEN_FAILED;
	return(-1);
    }
    if (*(command + 1) == '/') command ++;
    for (ls = 'p'; ls <= 's'; ls ++) {
	for (ln = 0; ln <= 0xF; ln ++) {
	    sprintf(ptyName, "/dev/pty%1c%1d", ls, ln);
	    if ((fd = open(ptyName, O_RDWR)) >= 0) break;
	}
	if (fd >= 0) break;
    }
    if (fd < 0) {
	LogError("PtyOpen");
	*status = OPEN_FAILED;
	return(-1);
    }
    ptyName[5] = 't';
    tcgetattr(fd, &oldTio);

    if ((ptyPid = fork()) < 0) {
	close(fd);
	*status = OPEN_FAILED;
	return(-1);
    }
    /*printf("[%s](%d)\n", command, ptyPid);*/
    if (ptyPid) {
	/* parent */
	newtio = oldTio;
	newtio.c_lflag &= ~(ECHO|ISIG|ICANON|XCASE);
	newtio.c_cflag |= CS8;
	newtio.c_iflag = 0;
	newtio.c_oflag &= ~OPOST;
	newtio.c_cc[VMIN] = 1;
	newtio.c_cc[VTIME] = 0;
#ifdef	HAVE_C_LINE
	newtio.c_line = 0;
#endif
	tcsetattr(fd, TCSAFLUSH, &newtio);
/*	fprintf(stderr, "master=%d\n", ptyPid);*/
    } else {
	/* child */
	int sfd, argc=1;
	char *argv[128];

	argv[0] = command;
	devname ++;
	while (*devname) {
	    argv[argc] = *devname;
	    argc ++;
	    devname ++;
	}
	argv[argc] = NULL;

	SuperPrivilege(TRUE);
	setsid();
	if ((sfd = open(ptyName, O_RDWR)) < 0) {
	    exit(-1);
	}
	close(fd);
	tcsetattr(sfd, TCSAFLUSH, &oldTio);
	dup2(sfd, 0);
	dup2(sfd, 1);
	dup2(sfd, 2);
	SuperPrivilege(FALSE);
	setgid(getgid());
	setuid(getuid());
	execv(argv[0], argv);
    }
    return(fd);
}

void
PtySetup()
{
    static struct device_s dev={
	NULL, PtyProbe, PtyOpen, AsyncWrite, AsyncRead, PtyClose, NULL
    };
    RegisterDevice(&dev);
}
