/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2003      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: sectionnode.h,v $
 * Revision 1.4  2003/03/06 14:54:30  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.3  2003/02/18 12:56:50  bdrieu
 * - Update to make prestimel compile with g++-3.2
 * - Use Magick++ instead of Magick
 *
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:50  slash
 * Initial release.
 *
 */

#ifndef SECTIONNODE_H
#define SECTIONNODE_H

#include "tocinterface.h"
#include "node.h"
#include "slidenode.h"

//---------------------------------------------------------------------------
/**
 * This class represents a section-node.
 * The purpose of this node is grouping several slide-nodes to one section.
 */
class SectionNode : public Node, TOCInterface { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the section-node.
     *
     * @param node The XML-node, which represents the section-node.
     */
    SectionNode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~SectionNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     * An integer-parameter has to be given because of the derivation,
     * but it won't be used in this class.
     *
     * @param parameter A dummy-parameter.
     */
    void writeHTML(int parameter=0) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;


    //-----------------------------------------------------------------------
    /**
     * This method writes the section to the table of contents.
     */
    void writeTOCEntry() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * The title of the section.
     */
    char *title_;

    //-----------------------------------------------------------------------
    std::vector<SlideNode*> child_nodes_;
};

#endif //SECTIONNODE_H
