/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2003      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: titlenode.cc,v $
 * Revision 1.6  2003/03/06 14:55:00  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.5  2003/02/26 12:28:34  benj
 * Clean up options a bit
 * Fix a crash when images are not found
 * Command option '-l' now has an optional argument
 * .tex files are now based on xml presentation name
 *
 * Revision 1.4  2003/02/25 15:54:19  benj
 * - Fix prestimel DTD where it had some flaws
 * - Create a <titlenode> environment because these informations has
 *   nothing to do in a slide <environment>
 *
 * Revision 1.3  2003/02/18 12:56:50  bdrieu
 * - Update to make prestimel compile with g++-3.2
 * - Use Magick++ instead of Magick
 *
 * Revision 1.2  2001/04/27 20:02:50  slash
 * Make use of xmlChildrenNode and xmlRootNode.
 *
 * Revision 1.1.1.1  2001/01/30 18:36:23  slash
 * Initial release.
 *
 */

#include "main.h"
#include "parameters.h"
#include "headingnode.h"
#include "authornode.h"
#include "datenode.h"
#include "titlenode.h"


//---------------------------------------------------------------------------
TitleNode::TitleNode(xmlNodePtr node) : SlideNode(node)
{
    for (node = node->xmlChildrenNode; node; node = node->next) {
        if (!strcmp((char*)node->name,"h2")) {
            child_nodes_.push_back(new HeadingNode(node, 2));
        } else if (!strcmp((char*)node->name,"h3")) {
            child_nodes_.push_back(new HeadingNode(node, 3));
        } else if (!strcmp((char*)node->name,"author")) {
            child_nodes_.push_back(new AuthorNode(node));
        } else if (!strcmp((char*)node->name,"date")) {
            child_nodes_.push_back(new DateNode(node));
        } else {
            Number_Of_Errors_++;
        }
    }
}

//---------------------------------------------------------------------------
TitleNode::~TitleNode()
{
}


//---------------------------------------------------------------------------
void TitleNode::writeHTML(int parameter) const
{
    // Determine the filename of this (sub)slide.
    char filename[64] = "01.html";

    // If we are inside of a section, the filename of the first slide
    // must be stored.
    if ((Section_Title_ != NULL) && (Section_Filename_[0] == '\0')) {
        strcpy(Section_Filename_, filename);
    }

    // This is first slide
    char filename_of_prev_slide[64] = "";

    // Determine the filename of the next slide.
    char filename_of_next_slide[64] = "02.html";

    // Write the slide to the HTML-file.
    Output_.open(filename);
    writeHTMLHeader(filename_of_prev_slide, filename_of_next_slide);
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeHTML();
    }
    writeHTMLFooter(filename_of_prev_slide, filename_of_next_slide);
    Output_.close();
}

//---------------------------------------------------------------------------
void TitleNode::writeLaTeX() const
{
    if (! Parameters_.isOutlineEnabled()) {
      Output_ << "\\begin{slide}" << std::endl;
    }
      
    Output_ << "\\begin{center}"
	    << std::endl
	    << "{\\Huge\\bf " 
	    << title_
	    << "}" 
	    << std::endl;

    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeLaTeX();
    }
    
    Output_ << std::endl
	    << "\\end{center}"
	    << std::endl;

    if (! Parameters_.isOutlineEnabled()) {
      Output_ << "\\end{slide}" << std::endl << std::endl;
    }
}

//---------------------------------------------------------------------------
void TitleNode::writeXML() const
{
    Output_ << "<title>" << std::endl;
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeXML();
    }
    Output_ << "</title>" << std::endl;
}


//---------------------------------------------------------------------------
int TitleNode::isHTMLStepped() const
{
    return 0;
}

//---------------------------------------------------------------------------
unsigned int TitleNode::getNumberOfHTMLSteps() const
{
    return 0;
}
