# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Hash", "Object", "class")
aClass.addFragment(Paragraph.new("A <code>Hash</code> is a collection of key-value pairs. It is similar to an <code>Array</code>, except that indexing is done via arbitrary keys of any object type, not an integer index. The order in which you traverse a hash by either key or value may seem arbitrary, and will generally not be in the insertion order.\n"))
aClass.addFragment(Paragraph.new("Hashes have a <em>default value</em> that is returned when accessing keys that do not exist in the hash. By default, that value is <code>nil</code>.\n"))
m0002 = MethodDesc.new("[]", "class", "Hash[ <i>[</i><i>key</i> => <i>value</i><i>]*</i> ] -> <i>aHash</i>")
m0002.addFragment(Paragraph.new("Creates a new hash populated with the given objects. Equivalent to the literal <code>{ <i>key</i>, <i>value</i>, ... }</code>. Keys and values occur in pairs, so there must be an even number of arguments.\n"))
m0002.addFragment(Verbatim.new("Hash[\"a\", 100, \"b\", 200]       \#=> {\"a\"=>100, \"b\"=>200}\nHash[\"a\" => 100, \"b\" => 200]   \#=> {\"a\"=>100, \"b\"=>200}\n{ \"a\" => 100, \"b\" => 200 }     \#=> {\"a\"=>100, \"b\"=>200}\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("new", "class", "Hash.new( <i>anObject</i>=<code>nil</code> ) -> <i>aHash</i>")
m0003.addFragment(Paragraph.new("Returns a new, empty hash. If <i>anObject</i> is specified, it will be used as the <em>default value</em>.\n"))
m0003.addFragment(Verbatim.new("h = Hash.new(\"Go Fish\")\nh[\"a\"] = 100\nh[\"b\"] = 200\nh[\"a\"]   \#=> 100\nh[\"c\"]   \#=> \"Go Fish\"\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("==", "instance", "<i>hsh</i> == <i>anOtherHash</i> -> <code>true</code> or <code>false</code>")
m0004.addFragment(Paragraph.new("Equality---Two hashes are equal if they each contain the same number of keys and if each key-value pair is equal to (according to <code>Object\#==</code>) the corresponding elements in the other hash.\n"))
m0004.addFragment(Verbatim.new("h1 = { \"a\" => 1, \"c\" => 2 }\nh2 = { \"a\" => 1, \"c\" => 2, 7 => 35 }\nh3 = { \"a\" => 1, \"c\" => 2, 7 => 35 }\nh4 = { \"a\" => 1, \"d\" => 2, \"f\" => 35 }\nh1 == h2   \#=> false\nh2 == h3   \#=> true\nh3 == h4   \#=> false\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("[]", "instance", "<i>hsh</i>[ <i>aKeyObject</i> ] -> <i>aValueObject</i>")
m0005.addFragment(Paragraph.new("Element Reference---Retrieves the <i>aValueObject</i> stored for <i>aKeyObject</i>. If not found, returns the <em>default value</em>.\n"))
m0005.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh[\"a\"]   \#=> 100\nh[\"c\"]   \#=> nil\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("[]=", "instance", "<i>hsh</i>[ <i>aKeyObject</i> ] = <i>aValueObject</i> -> <i>aValueObject</i>")
m0006.addFragment(Paragraph.new("Element Assignment---Associates the value given by <i>aValueObject</i> with the key given by <i>aKeyObject</i>. <i>aKeyObject</i> should not have its value changed while it is in use as a key (a <code>String</code> passed as a key will be duplicated and frozen).\n"))
m0006.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh[\"a\"] = 9\nh[\"c\"] = 4\nh   \#=> {\"a\"=>9, \"b\"=>200, \"c\"=>4}\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("clear", "instance", "<i>hsh</i>.clear -> <i>hsh</i>")
m0007.addFragment(Paragraph.new("Removes all key-value pairs from <i>hsh</i>.\n"))
m0007.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }   \#=> {\"a\"=>100, \"b\"=>200}\nh.clear                          \#=> {}\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("default", "instance", "<i>hsh</i>.default -> <i>anObject</i>")
m0008.addFragment(Paragraph.new("Returns the ``<em>default value</em>''---that is, the value returned for a key that does not exist in the hash. Defaults to <code>nil</code>. See also <code>Hash\#default=</code>.\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("default=", "instance", "<i>hsh</i>.default = <i>anObject</i> -> <i>hsh</i>")
m0009.addFragment(Paragraph.new("Sets the ``<em>default value</em>''---that is, the value returned for a key that does not exist in the hash. Defaults to <code>nil</code>.\n"))
m0009.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.default = \"Go fish\"\nh[\"a\"]   \#=> 100\nh[\"z\"]   \#=> \"Go fish\"\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("delete", "instance", "<i>hsh</i>.delete( <i>aKeyObject</i> ) -> <i>aValueObject</i><br></br><i>hsh</i>.delete( <i>aKeyObject</i> ) {| aKeyObject | block } <p></p> -> <i>aValueObject</i> <p></p>")
m0010.addFragment(Paragraph.new("Deletes and returns a key-value pair from <i>hsh</i> whose key is equal to <i>aKeyObject</i>. If the key is not found, returns the <em>default value</em>. If the optional code block is given and the key is not found, pass in the key and return the result of <i>block</i>.\n"))
m0010.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.delete(\"a\")                              \#=> 100\nh.delete(\"z\")                              \#=> nil\nh.delete(\"z\") { |el| \"\#{el} not found\" }   \#=> \"z not found\"\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("delete_if", "instance", "<i>hsh</i>.delete_if {| key, value | block } <p></p> -> <i>hsh</i>")
m0011.addFragment(Paragraph.new("Deletes every key-value pair from <i>hsh</i> for which <i>block</i> evaluates to <code>true</code>.\n"))
m0011.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200, \"c\" => 300 }\nh.delete_if {|key, value| key >= \"b\" }   \#=> {\"a\"=>100}\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("each", "instance", "<i>hsh</i>.each {| key, value | block } -> <i>hsh</i>")
m0012.addFragment(Paragraph.new("Calls <i>block</i> once for each key in <i>hsh</i>, passing the key and value as parameters.\n"))
m0012.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.each {|key, value| print key, \" is \", value, \"\\n\" }"))
m0012.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0012.addFragment(Verbatim.new("a is 100\nb is 200"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("each_key", "instance", "<i>hsh</i>.each_key {| key | block } -> <i>hsh</i>")
m0013.addFragment(Paragraph.new("Calls <i>block</i> once for each key in <i>hsh</i>, passing the key as a parameter.\n"))
m0013.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.each_key {|key| puts key }"))
m0013.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0013.addFragment(Verbatim.new("a\nb"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("each_pair", "instance", "<i>hsh</i>.each_pair {| key, value | block } -> <i>hsh</i>")
m0014.addFragment(Paragraph.new("Synonym for <code>Hash\#each</code>.\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("each_value", "instance", "<i>hsh</i>.each_value {| value | block } -> <i>hsh</i>")
m0015.addFragment(Paragraph.new("Calls <i>block</i> once for each key in <i>hsh</i>, passing the value as a parameter.\n"))
m0015.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.each_value {|value| puts value }"))
m0015.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0015.addFragment(Verbatim.new("100\n200"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("empty?", "instance", "<i>hsh</i>.empty? -> <code>true</code> or <code>false</code>")
m0016.addFragment(Paragraph.new("Returns <code>true</code> if <i>hsh</i> contains no key-value pairs.\n"))
m0016.addFragment(Verbatim.new("{}.empty?   \#=> true\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("fetch", "instance", "<i>hsh</i>.fetch( <i>aKeyObject</i> <i>[</i>, <i>aDefObject</i><i>]</i> ) -> <i>anObject</i><br></br><i>hsh</i>.fetch( <i>aKeyObject</i> ) {| aKeyObject | block } <p></p> -> <i>anObject</i>")
m0017.addFragment(Paragraph.new("Returns a value from the hash for the given key. If the key can't be found, there are several options: With no other arguments, it will raise an <code>IndexError</code> exception; if <i>aDefObject</i> is given, then that will be returned; if the optional code block is specified, then that will be run and its result returned.\n"))
m0017.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.fetch(\"a\")                            \#=> 100\nh.fetch(\"z\", \"go fish\")                 \#=> \"go fish\"\nh.fetch(\"z\") { |el| \"go fish, \#{el}\"}   \#=> \"go fish, z\"\n"))
m0017.addFragment(Paragraph.new("The following example shows that an exception is raised if the key is not found and a default value is not supplied.\n"))
m0017.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.fetch(\"z\")"))
m0017.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0017.addFragment(Verbatim.new("prog.rb:2:in `fetch': key not found (IndexError)\n\tfrom prog.rb:2"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("has_key?", "instance", "<i>hsh</i>.has_key?( <i>aKeyObject</i> ) -> <code>true</code> or <code>false</code>")
m0018.addFragment(Paragraph.new("Returns <code>true</code> if the given key is present in <i>hsh</i>.\n"))
m0018.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.has_key?(\"a\")   \#=> true\nh.has_key?(\"z\")   \#=> false\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("has_value?", "instance", "<i>hsh</i>.has_value?( <i>aValueObject</i> ) -> <code>true</code> or <code>false</code>")
m0019.addFragment(Paragraph.new("Returns <code>true</code> if the given value is present for some key in <i>hsh</i>.\n"))
m0019.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.has_value?(100)   \#=> true\nh.has_value?(999)   \#=> false\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("include?", "instance", "<i>hsh</i>.include?( <i>aKeyObject</i> ) -> <code>true</code> or <code>false</code>")
m0020.addFragment(Paragraph.new("Synonym for <code>Hash\#has_key?</code>.\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("index", "instance", "<i>hsh</i>.index( <i>aValueObject</i> ) -> <i>aKeyObject</i>")
m0021.addFragment(Paragraph.new("Returns the key for a given value. If not found, returns the <em>default value</em>.\n"))
m0021.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.index(200)   \#=> \"b\"\nh.index(999)   \#=> nil\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("indexes", "instance", "<i>hsh</i>.indexes( <i>[</i><i>key</i><i>]+></i> ) -> <i>anArray</i>")
m0022.addFragment(Paragraph.new("Returns a new array consisting of values for the given key(s). Will insert the <em>default value</em> for keys that are not found.\n"))
m0022.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200, \"c\" => 300 }\nh.indexes(\"a\", \"c\")        \#=> [100, 300]\nh.indexes(\"a\", \"c\", \"z\")   \#=> [100, 300, nil]\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("indices", "instance", "<i>hsh</i>.indices( <i>[</i><i>key</i><i>]+></i> ) -> <i>anArray</i>")
m0023.addFragment(Paragraph.new("Synonym for <code>Hash\#indexes</code>.\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("invert", "instance", "<i>hsh</i>.invert -> <i>aHash</i>")
m0024.addFragment(Paragraph.new("Returns a new hash created by using <i>hsh</i>'s values as keys, and the keys as values.\n"))
m0024.addFragment(Verbatim.new("h = { \"n\" => 100, \"m\" => 100, \"y\" => 300, \"d\" => 200, \"a\" => 0 }\nh.invert   \#=> {200=>\"d\", 300=>\"y\", 0=>\"a\", 100=>\"n\"}\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("key?", "instance", "<i>hsh</i>.key?( <i>aKeyObject</i> ) -> <code>true</code> or <code>false</code>")
m0025.addFragment(Paragraph.new("Synonym for <code>Hash\#has_key?</code>.\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("keys", "instance", "<i>hsh</i>.keys -> <i>anArray</i>")
m0026.addFragment(Paragraph.new("Returns a new array populated with the keys from this hash. See also <code>Hash\#values</code>.\n"))
m0026.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200, \"c\" => 300, \"d\" => 400 }\nh.keys   \#=> [\"a\", \"b\", \"c\", \"d\"]\n"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("length", "instance", "<i>hsh</i>.length -> <i>aFixnum</i>")
m0027.addFragment(Paragraph.new("Returns the number of key-value pairs in the hash.\n"))
m0027.addFragment(Verbatim.new("h = { \"d\" => 100, \"a\" => 200, \"v\" => 300, \"e\" => 400 }\nh.length        \#=> 4\nh.delete(\"a\")   \#=> 200\nh.length        \#=> 3\n"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("member?", "instance", "<i>hsh</i>.member?( <i>aKeyObject</i> ) -> <code>true</code> or <code>false</code>")
m0028.addFragment(Paragraph.new("Synonym for <code>Hash\#has_key?</code>.\n"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("rehash", "instance", "<i>hsh</i>.rehash -> <i>hsh</i>")
m0029.addFragment(Paragraph.new("Rebuilds the hash based on the current hash values for each key. If values of key objects have changed since they were inserted, this method will reindex <i>hsh</i>. If <code>Hash\#rehash</code> is called while an iterator is traversing the hash, an <code>IndexError</code> will be raised in the iterator.\n"))
m0029.addFragment(Verbatim.new("a = [ \"a\", \"b\" ]\nc = [ \"c\", \"d\" ]\nh = { a => 100, c => 300 }\nh[a]       \#=> 100\na[0] = \"z\"\nh[a]       \#=> nil\nh.rehash   \#=> {[\"c\", \"d\"]=>300, [\"z\", \"b\"]=>100}\nh[a]       \#=> 100\n"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("reject", "instance", "<i>hsh</i>.reject {| key, value | block } <p></p> -> <i>aHash</i>")
m0030.addFragment(Paragraph.new("Same as <code>Hash\#delete_if</code>, but works on (and returns) a copy of the <i>hsh</i>. Equivalent to <code><i>hsh</i>.dup.delete_if</code>.\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("reject!", "instance", "<i>hsh</i>.reject! {| key, value | block } <p></p> -> <i>hsh</i> or <code>nil</code>")
m0031.addFragment(Paragraph.new("Equivalent to <code>Hash\#delete_if</code>, but returns <code>nil</code> if no changes were made.\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("replace", "instance", "<i>hsh</i>.replace( <i>anOtherHash</i> ) -> <i>hsh</i>")
m0032.addFragment(Paragraph.new("Replaces the contents of <i>hsh</i> with the contents of <i>anOtherHash</i>.\n"))
m0032.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200 }\nh.replace({ \"c\" => 300, \"d\" => 400 })   \#=> {\"c\"=>300, \"d\"=>400}\n"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("shift", "instance", "<i>hsh</i>.shift -> <i>anArray</i> or <code>nil</code>")
m0033.addFragment(Paragraph.new("Removes a key-value pair from <i>hsh</i> and returns it as the two-item array <code>[</code> <i>key, value</i> <code>]</code>, or <code>nil</code> if the hash is empty.\n"))
m0033.addFragment(Verbatim.new("h = { 1 => \"a\", 2 => \"b\", 3 => \"c\" }\nh.shift   \#=> [1, \"a\"]\nh         \#=> {2=>\"b\", 3=>\"c\"}\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("size", "instance", "<i>hsh</i>.size -> <i>aFixnum</i>")
m0034.addFragment(Paragraph.new("Synonym for <code>Hash\#length</code>.\n"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("sort", "instance", "<i>hsh</i>.sort -> <i>anArray</i> <br></br><i>hsh</i>.sort {| a, b | block } <p></p> -> <i>anArray</i> <p></p>")
m0035.addFragment(Paragraph.new("Converts <i>hsh</i> to a nested array of <code>[</code> <i>key, value</i> <code>]</code> arrays and sorts it, using <code>Array\#sort</code>.\n"))
m0035.addFragment(Verbatim.new("h = { \"a\" => 20, \"b\" => 30, \"c\" => 10  }\nh.sort                       \#=> [[\"a\", 20], [\"b\", 30], [\"c\", 10]]\nh.sort {|a,b| a[1]<=>b[1]}   \#=> [[\"c\", 10], [\"a\", 20], [\"b\", 30]]\n"))
aClass.addMethod(m0035)
m0036 = MethodDesc.new("store", "instance", "<i>hsh</i>.store( <i>aKeyObject, aValueObject</i> ) -> <i>aValueObject</i>")
m0036.addFragment(Paragraph.new("Synonym for Element Assignment (<code>Hash\#[]=</code>).\n"))
aClass.addMethod(m0036)
m0037 = MethodDesc.new("to_a", "instance", "<i>hsh</i>.to_a -> <i>anArray</i>")
m0037.addFragment(Paragraph.new("Converts <i>hsh</i> to a nested array of <code>[</code> <i>key, value</i> <code>]</code> arrays.\n"))
m0037.addFragment(Verbatim.new("h = { \"c\" => 300, \"a\" => 100, \"d\" => 400, \"c\" => 300  }\nh.to_a   \#=> [[\"a\", 100], [\"c\", 300], [\"d\", 400]]\n"))
aClass.addMethod(m0037)
m0038 = MethodDesc.new("to_s", "instance", "<i>hsh</i>.to_s -> <i>aString</i>")
m0038.addFragment(Paragraph.new("Converts <i>hsh</i> to a string by converting the hash to an array of <code>[</code> <i>key, value</i> <code>]</code> pairs and then converting that array to a string using <code>Array\#join</code> with the default separator.\n"))
m0038.addFragment(Verbatim.new("h = { \"c\" => 300, \"a\" => 100, \"d\" => 400, \"c\" => 300  }\nh.to_s   \#=> \"a100c300d400\"\n"))
aClass.addMethod(m0038)
m0039 = MethodDesc.new("update", "instance", "<i>hsh</i>.update( <i>anOtherHash</i> ) -> <i>hsh</i>")
m0039.addFragment(Paragraph.new("Adds the contents of <i>anOtherHash</i> to <i>hsh</i>, overwriting entries with duplicate keys with those from <i>anOtherHash</i>.\n"))
m0039.addFragment(Verbatim.new("h1 = { \"a\" => 100, \"b\" => 200 }\nh2 = { \"b\" => 254, \"c\" => 300 }\nh1.update(h2)   \#=> {\"a\"=>100, \"b\"=>254, \"c\"=>300}\n"))
aClass.addMethod(m0039)
m0040 = MethodDesc.new("value?", "instance", "<i>hsh</i>.value?( <i>aValueObject</i> ) -> <code>true</code> or <code>false</code>")
m0040.addFragment(Paragraph.new("Synonym for <code>Hash\#has_value?</code>.\n"))
aClass.addMethod(m0040)
m0041 = MethodDesc.new("values", "instance", "<i>hsh</i>.values -> <i>anArray</i>")
m0041.addFragment(Paragraph.new("Returns a new array populated with the values from <i>hsh</i>. See also <code>Hash\#keys</code>.\n"))
m0041.addFragment(Verbatim.new("h = { \"a\" => 100, \"b\" => 200, \"c\" => 300 }\nh.values   \#=> [100, 200, 300]\n"))
aClass.addMethod(m0041)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
