/*
 Unix snprintf implementation.
 Version 1.1
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   Revision History:

   sitecopy changes:
       added sys/types.h include to pick up size_t define.
       renamed dtoa -> doubletoa to avoid dtoa conflict with cygwin.

   1.1:
      *  added changes from Miles Bader
      *  corrected a bug with %f
      *  added support for %#g
      *  added more comments :-)
   1.0:
      *  supporting must ANSI syntaxic_sugars(see below)
   0.0:
      *  suppot %s %c %d

    it understands:
      Integer:
        %lu %lu %u
        %hd %ld %d     decimal
        %ho %lo %o     octal
        %hx %lx %x %X  hexa
      Floating points:
        %g %G %e %E %f  double
      Strings:
        %s %c  string
        %%   %

    Formating conversion flags:
      - justify left
      + Justify right or put a plus if number
      # prefix 0x, 0X for hexa and 0 for octal
      * precision/witdth is specify as an (int) in the arguments
    ' ' leave a blank for number with no sign
      l the later should be a long
      h the later should be a short

format:
  snprintf(holder, sizeof_holder, format, ...)

Return values:
  (sizeof_holder - 1)


 THANKS(for the patches and ideas):
     Miles Bader
     Cyrille Rustom
     Jacek Slabocewiz
     Mike Parker(mouse)

Alain Magloire: alainm@rcsm.ee.mcgill.ca
*/

#ifndef SNPRINTF_H
#define SNPRINTF_H 1

#if defined(HAVE_STDARG_H) && defined(__STDC__) && __STDC__
/**** changed for sitecopy ****/
#include <sys/types.h>
#include <stdarg.h>
#else
#include <varargs.h>
#endif


int snprintf
#if defined(HAVE_STDARG_H) && defined(__STDC__) && __STDC__
(char *string, size_t length, const char * format, ...);
#else
(string, length, format, va_alist);
char *string;
size_t length;
char * format;
va_dcl
#endif

int vsnprintf
#ifdef __STDC__
(char *string, size_t length, const char * format, va_list args);
#else
    (string, length, format, args);
char *string;
size_t length;
char * format;
va_list args;
#endif

#endif /* SNPRINTF */
