import LoginManager, LoginMethods, UserSources
from ImageFile import ImageFile


def initialize(context):
    UserSources.initialize(context)
    
    context.registerClass(
        LoginManager.LoginManager,
        permission = 'Add Login Managers',
        constructors = (LoginManager.manage_addLoginManagerForm,
                        LoginManager.manage_addLoginManager),
        icon = 'www/folder.gif',
    )

    context.registerPIContainerBase(LoginManager.LoginManager)

    context.registerPlugInClass(
        LoginMethods.RemoteUserLogin,
        'REMOTE_USER Login',
        permission = 'Add REMOTE_USER Login',
        constructors = (LoginMethods.manage_addRemoteUserLoginForm,
                        LoginMethods.manage_addRemoteUserLogin),
    )

    context.registerPlugInClass(
        LoginMethods.BasicAuth,
        'Basic Auth Login',
        permission = 'Add Basic Auth Login',
        constructors = (LoginMethods.manage_addBasicAuthLoginForm,
                        LoginMethods.manage_addBasicAuthLogin),
    )

    context.registerPlugInClass(
        LoginMethods.BasicCookieLogin,
        'Basic Cookie Login',
        permission = 'Add Basic Cookie Login',
        constructors = (LoginMethods.manage_addBasicCookieLoginForm,
                        LoginMethods.manage_addBasicCookieLogin),
    )

    if hasattr(context,'registerHelp'):
        context.registerHelp()

# Misc. www stuff

misc_={
    'loginmethod': ImageFile('www/loginmethod.gif', globals()),
    'user': ImageFile('www/user.gif', globals()),
    'usersource': ImageFile('www/usersource.gif', globals()),
}


# Backward compatibility
_ZClass_for_LoginUser = UserSources._ZClass_for_LoginUser
