#ifndef QPIPE_H
#define QPIPE_H

#include<qstring.h>
#include<qcstring.h>

#ifdef Q_WS_WIN
#include<windows.h>
typedef HANDLE QPipeId;
#else
typedef int QPipeId;
#endif

class QPipeEnd
{
public:
	enum { Read, Write };
	QPipeEnd();
	~QPipeEnd();

	bool isOpen() const;
	const QPipeId & id() const;
	void setId(const QPipeId &);

	void close();
	void release();

	QString toString() const;

	int write(const QByteArray &);
	QByteArray readAll(bool *done=0);

#ifdef Q_WS_WIN
	bool winDupHandle();
#else
	bool setBlock(bool b);
#endif

private:
	QPipeId p;

	void reset();
};

class QPipe
{
public:
	QPipe();
	~QPipe();

	void closeReadEnd();
	void closeWriteEnd();

	int write(const QByteArray &);
	QByteArray readAll(bool *done=0);

	QPipeEnd & readEnd() { return i; }
	QPipeEnd & writeEnd() { return o; }

	bool open();
	void close();
	void release();

private:
	QPipeEnd i, o;
};

#endif
