/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <stdarg.h>
#include <stdio.h>
#include "FileSelection.h"
#include "XMString.h"

FileSelection::FileSelection()
{
}

FileSelection::~FileSelection()
{
}


bool FileSelection::ask(const char* title,
	const char* file,const char* filter,
	const char* dir)
{
	return instance().choose(title,file,filter,dir);
}


bool FileSelection::choose(const char* title,
	const char* deffile,const char* filter,
	const char* directory)

{
	set(XmNdirSpec,deffile);
	set(XmNpattern,filter);
	set(XmNdirectory,directory);

	return instance().modal(title,true);
}

const string& FileSelection::file()
{
	return instance().file_;
}

void FileSelection::set(const char* res,const char* val)
{
	if(!val) return;

	XMString s(val);
	XtVaSetValues(form_,res,XmString(s),0);
}

void FileSelection::okCB(Widget,XtPointer data)
{								
	XmFileSelectionBoxCallbackStruct* cb = (XmFileSelectionBoxCallbackStruct*)data;
	string f = XMString(cb->value);
	string d = XMString(cb->dir);

	if(f[0] == '/') file_ = f;
	else file_ = d + f;

	if(file_[file_.length() - 1] == '/')
		file_.resize(file_.length() - 1);

	ok_   = true;
	stop_ = true;
}
