// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef MEDIAVIEW_H
#define MEDIAVIEW_H

#include <qlistview.h>
#include <qiconset.h>
#include <qvaluelist.h>

class Group;
class Organizer;
class Song;

class QAction;
class QPopupMenu;
class QTimer;


class MediaView : public QListView
{
    Q_OBJECT

public:
    MediaView(QWidget *, const char * = 0);
    ~MediaView();

    void setupActions();
    void setupMenus();
    void setupToolbars();

    void loadIcons();
    void xmlDescription(QTextStream &) const;

    void updateSongLengths();

    QPopupMenu *mainMenu() { return mainmenu; }

    bool isModified() const { return modified; }

    static MediaView *instance();


public slots:
    void load();
    void save();
    void addSong();
    void editSong();
    void remSong();
    void addGroup();
    void addRootGroup();
    void editGroup();
    void remGroup();
    void buildFromDir();
    void remAll();


protected:
    void contentsMousePressEvent(QMouseEvent *);
    void contentsMouseReleaseEvent(QMouseEvent *);
    void contentsMouseMoveEvent(QMouseEvent *);
    void contentsDragEnterEvent(QDragEnterEvent *);
    void contentsDragMoveEvent(QDragMoveEvent *);
    void contentsDragLeaveEvent(QDragLeaveEvent *);
    void contentsDropEvent(QDropEvent *);


protected slots:
    void timeout();
    void popupContextMenu(QListViewItem *, const QPoint &, int);
    void itemHighlighted(QListViewItem *);
    void itemSelected(QListViewItem *);
    void doLengthCalc();

    void addGroupPrio(Group *, int);
    void setGroupEnabled(Group *, bool);
    void setGroupEqualizer(Group *, const QString &);
    void groupStatus(Group *, int &, int &, QString &);
    void enableAll();
    void disableAll();
    void incPrio();
    void decPrio();
    void incPrio5();
    void decPrio5();


signals:
    void songSelected();


private:
    bool isBChildOfA(QListViewItem *, QListViewItem *) const;
    void setModified(bool m) { modified = m; }

    QAction *actionAddSong, *actionAddGroup, *actionAddRootGroup,
	*actionRemSong, *actionRemGroup,
	*actionEditSong, *actionEditGroup,
	*actionBldFromDir,
	*actionRemAll,
	*actionGroupEnableAll, *actionGroupDisableAll,
	*actionMediaEnableAll, *actionMediaDisableAll,
	*actionIncPrio, *actionDecPrio, *actionIncPrio5, *actionDecPrio5;
    QIconSet iconset;
    QListViewItem *oldcurrent, *dropitem, *dragitem;
    QTimer *timer;
    QPoint presspos;
    QPopupMenu *mainmenu, *groupmenu, *songmenu, *priomenu;
    QTimer *lengthTimer;
    QValueList<Song*> lengthlist;
    bool pressed, supportedgroup, supportedsong, supporteduri, dragging, modified;

    friend class Group;
    friend class Song;
};

#endif // MEDIAVIEW_H
