/* $Id: sfskeycert.C,v 1.2 1999/11/29 23:09:21 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "sfskey.h"

void
sfskey_certclear (int argc, char **argv)
{
  nularg (argc, argv);
  if (clnt_stat err = cagent ()->scall (AGENTCTL_CLRCERTPROGS, NULL, NULL))
    fatal << "agent: " << err << "\n";
  exit (0);
}

void
sfskey_certlist (int argc, char **argv)
{
  bool opt_q = false;
  int ch;
  while ((ch = getopt (argc, argv, "q")) != -1)
    switch (ch) {
    case 'q':
      opt_q = true;
      break;
    default:
      usage ();
      break;
    }
  if (optind < argc)
    usage ();

  sfsagent_certprogs res;
  if (clnt_stat err = cagent ()->scall (AGENTCTL_DUMPCERTPROGS, NULL, &res))
    fatal << "agent: " << err << "\n";

  strbuf list;
  if (!opt_q)
    list.fmt ("%-8s %-8s %-8s %s\n", "SUFFIX", "FILTER", "EXCLUDE", "PROGRAM");
  for (sfsagent_certprog *p = res.base (); p < res.lim (); p++) {
    list.fmt ("%-8s %-8s %-8s", p->suffix.cstr (),
	      p->filter.cstr (), p->exclude.cstr ());
    for (sfsagent_progarg *a = p->av.base (); a < p->av.lim (); a++)
      list << " " << *a;
    list << "\n";
  }

  make_sync (1);
  list.tosuio ()->output (1);
  exit (0);
}

void
sfskey_certprog (int argc, char **argv)
{
  sfsagent_certprog arg;

  int ch;
  while ((ch = getopt (argc, argv, "s:f:e:")) != -1)
    switch (ch) {
    case 's':
      if (arg.suffix)
	usage ();
      arg.suffix = strbuf () << "." << optarg;
      break;
    case 'f':
      if (arg.filter)
	usage ();
      arg.filter = optarg;
      break;
    case 'e':
      if (arg.exclude)
	usage ();
      arg.exclude = optarg;
      break;
    default:
      usage ();
      break;
    }
  if (optind >= argc)
    usage ();

  if (!arg.suffix)
    arg.suffix = "";
  if (!arg.filter)
    arg.filter = "";
  if (!arg.exclude)
    arg.exclude = "";

  arg.av.setsize (argc - optind);
  for (int i = optind; i < argc; i++)
    arg.av[i - optind] = argv[i];
  bool res;
  if (clnt_stat err = cagent ()->scall (AGENTCTL_ADDCERTPROG, &arg, &res))
    fatal << "agent: " << err << "\n";
  if (!res)
    fatal << "agent refused certification program\n";
  exit (0);
}
