/* $Id: tcpconnect.C,v 1.4 2000/06/02 01:38:36 dm Exp $ */

/*
 *
 * Copyright (C) 1998 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "async.h"
#include "dns.h"

static void
tcpconnect_addr_cb (int fd, cbi cb)
{
  fdcb (fd, selwrite, NULL);

  sockaddr_in sin;
  socklen_t sn = sizeof (sin);
  if (!getpeername (fd, (sockaddr *) &sin, &sn)) {
    (*cb) (fd);
    return;
  }

  int err = 0;
  sn = sizeof (err);
  getsockopt (fd, SOL_SOCKET, SO_ERROR, (char *) &err, &sn);
  close (fd);
  errno = err ? err : ECONNREFUSED;
  (*cb) (-1);
}

void
tcpconnect (in_addr addr, u_int16_t port, cbi cb)
{
  sockaddr_in sin;
  bzero (&sin, sizeof (sin));
  sin.sin_family = AF_INET;
  sin.sin_port = htons (port);
  sin.sin_addr = addr;

  int fd = inetsocket (SOCK_STREAM);
  if (fd < 0) {
    (*cb) (-1);
    return;
  }
  make_async (fd);
  close_on_exec (fd);
  if (connect (fd, (sockaddr *) &sin, sizeof (sin)) < 0
      && errno != EINPROGRESS) {
    close (fd);
    (*cb) (-1);
    return;
  }
  fdcb (fd, selwrite, wrap (tcpconnect_addr_cb, fd, cb));
}

static void
tcpconnect_name_cb (u_int16_t port, str *namep,
		    cbi cb, ptr<hostent> h, int err)
{
  if (!h) {
    errno = ENOENT;
    (*cb) (-1);
    return;
  }
  if (namep)
    *namep = h->h_name;
  tcpconnect (*(in_addr *) h->h_addr, port, cb);
}

void
tcpconnect (str hostname, u_int16_t port, cbi cb, bool dnssearch,
	    str *namep)
{
  dns_hostbyname (hostname, wrap (tcpconnect_name_cb, port, namep, cb),
		  dnssearch);
}
