// -*-c++-*-
/* $Id: authdb.h,v 1.9 2001/01/13 19:46:11 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 * Copyright (C) 1999 Michael Kaminsky (kaminsky@lcs.mit.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#ifndef _AUTHDB_H_
#define _AUTHDB_H_

#include "arpc.h"

/*
 * Store parsed data read from file. Doesn't do mapping or prefixing.
 */
struct authentry {
  str keyname;
  str pubkey;
  str privs;
  str srpinfo;
  str privkey;
};

/*
 * Store state from parsing:
 *     Userfile [-ro] [-prefix=<prefix>] [-pub=<filename>] \
 *       [-mapall=<privs>] <userfilename>
 */
struct userfile {
  const str path;		// path to writable version
  const str pub;		// path to public non-SRP version
  const bool ro;		// whether these files are to be updated
  const str prefix;		// create a namespace
  const str mapall;		// grouping users
  const bool reg;		// registration okay?
  const str dbpath;		// Path to local copy
  pid_t xferpid;		// Transfer in progress
  
  static str mkdbpath (str path);
  str remprefix (str keyname);
  explicit userfile (const str &path, const str &pub = NULL, bool ro = false,
		     const str &prefix = NULL, const str &mapall = NULL,
		     bool reg = false);
  void xferdone (int status) { xferpid = -1; }
  bool lookup (authentry *e);
  sfsauth_stat update (authentry *e, bool add = false);
};

extern vec<userfile> userfiles;

/* authlookup --
 *   Looks up a keyname or public key from the known userfiles.
 *   Mapping and prefixing happens here.
 *   If found, returns true and modifies arg to contain full info.
 */
bool authlookup (authentry *);
bool authadd (authentry *);
bool authupdate (authentry *);
void authdbinit ();

#ifndef HAVE_GETGROUPLIST
extern "C" int getgrouplist(const char *uname, GROUPLIST_T agroup,
			    GROUPLIST_T *groups, int *grpcnt);
#endif /* !HAVE_GETGROUPLIST */

#endif _AUTHDB_H_
