/* $Id: authmisc.C,v 1.5 2001/01/13 19:46:11 dm Exp $ */

/*
 *
 * Copyright (C) 1999 Michael Kaminsky (kaminsky@lcs.mit.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "authserv.h"
#include "parseopt.h"
#include "grp.h"

str denyfile;

extern "C" char *getusershell(void);
extern "C" void setusershell(void);
extern "C" void endusershell(void);

bool
unixlookup (authentry *e, sfs_unixcred *au)
{
  struct passwd *pe;

  if ((pe = getpwnam (e->privs)) == NULL)
    return false;

  GROUPLIST_T groups[NGROUPS_MAX];
  int ngroups = NGROUPS_MAX;
  getgrouplist (pe->pw_name, pe->pw_gid, groups, &ngroups);

  au->username = pe->pw_name;
  au->homedir = pe->pw_dir;
  au->shell = pe->pw_shell;
  au->uid = pe->pw_uid;
  au->gid = pe->pw_gid;
  au->groups.setsize (ngroups);
  for (int i = 0; i < ngroups; i++)
    au->groups[i] = groups[i];

  return true;
}

bool
validshell (char *shell)
{
  char *s;

  setusershell ();
  while ((s = getusershell ()))
    if (!strcmp(s, shell)) {
      endusershell ();
      return true;
    }

  return false;
}

bool
indenyfile (str username)
{
  if (!denyfile)
    return false;

  parseargs pa (denyfile);
  int line;
  vec<str> av;

  while (pa.getline (&av, &line)) {
    if (!strcasecmp (av[0], username))
      return true;
  }

  return false;
}
