/*
 * Cryptographic Functions Common Header
 *
 * Production Implementation, (c) 1999 Andreas Steinmetz
 *
 * License:
 * This code is in the 'public domain' (*) under the GNU public license
 * for use with the virtual private network daemon (vpnd).
 * The copyright holder will however retain the copyright.
 * In addition to vpnd this code is put in the 'public domain' (*)
 * for all GPL/LGPL based open source software products.
 * For all other software products please contact astmail@yahoo.com
 * for a license agreement. There is no guarantee for the fitness
 * and usability of this code for any purpose. The author takes no
 * responsibility for any damages caused by the use of this code.
 * Distribution and use of this code is explicitly granted provided
 * that the above header is not modified and the above conditions
 * are met.
 * (*) 'public domain' is used here in the sense of the Wassenaar treaty.
 *
 * This implementation is tuned for speed and should be 64 bit clean.
 *
 * Data sizes:
 *
 * WORD08 means an unsigned word of 8 bits length
 * WORD16 means an unsigned word of at least 16 bits length
 * WORD32 means an unsigned word of at least 32 bits length
 *
 */

/* get simple type sizes */

#include <limits.h>

/* assert that required definitions are not yet defined */

#ifdef WORD08
#undef WORD08
#endif

#ifdef WORD16
#undef WORD16
#endif

#ifdef WORD32
#undef WORD32
#endif

#ifdef WORD64
#undef WORD64
#endif

#ifdef BITS16
#undef BITS16
#endif

#ifdef BITS32
#undef BITS32
#endif

#ifdef BITS64
#undef BITS64
#endif

/* make sure unsigned char is 8 bits wide */

#if UCHAR_MAX == 0xff
#define WORD08 unsigned char
#else
#error No 8 bit value available
#endif

/* make sure that WORD16 is at least 16 bits wide,
   default the macro BITS16 to nothing if WORD16
   is exactly 16 bits wide */

#if USHRT_MAX == 0xffff
#define WORD16 unsigned short
#define BITS16(a) (a)
#elif ULONG_MAX == 0xffff
#define WORD16 unsigned long
#define BITS16(a) (a)
#elif USHRT_MAX > 0xffff
#define BITS16(a) ((a)&0xffff)
#define WORD16 unsigned short
#elif ULONG_MAX > 0xffff
#define WORD16 unsigned long
#define BITS16(a) ((a)&0xffff)
#else
#error No 16 bit value available
#endif

/* make sure that WORD32 is at least 32 bits wide,
   default the macro BITS32 to nothing if WORD32
   is exactly 32 bits wide */

#if USHRT_MAX == 0xffffffff
#define WORD32 unsigned short
#define BITS32(a) (a)
#elif ULONG_MAX == 0xffffffff
#define WORD32 unsigned long
#define BITS32(a) (a)
#elif USHRT_MAX > 0xffffffffUL
#define WORD32 unsigned short
#define BITS32(a) ((a)&0xffffffff)
#elif ULONG_MAX > 0xffffffffUL
#define WORD32 unsigned long
#define BITS32(a) ((a)&0xffffffff)
#else
#error No 32 bit value available
#endif

/* set WORD64 and BITS64 if we are on a 64 bit machine */

#ifdef ULLONG_MAX
#if USHRT_MAX == 0xffffffffffffffff
#define WORD64 unsigned short
#define BITS64(a) (a)
#elif ULONG_MAX == 0xffffffffffffffff
#define WORD64 unsigned long
#define BITS64(a) (a)
#elif ULLONG_MAX == 0xffffffffffffffff
#define WORD64 unsigned long long
#define BITS64(a) (a)
#elif USHRT_MAX > 0xffffffffffffffff
#define WORD64 unsigned short
#define BITS64(a) ((a)&0xffffffffffffffff)
#elif ULONG_MAX > 0xffffffffffffffff
#define WORD64 unsigned long
#define BITS64(a) ((a)&0xffffffffffffffff)
#elif ULLONG_MAX > 0xffffffffffffffff
#define WORD64 unsigned long long
#define BITS64(a) ((a)&0xffffffffffffffff)
#endif
#endif

/* use defined calling conventions for WIN32 */

#ifdef _WIN32
#define FASTCALL __fastcall
#ifdef _M_IX86
#if _M_IX86==300
#define CRYPTOCALL __fastcall
#else
#define CRYPTOCALL __cdecl
#endif
#else
#define CRYPTOCALL __fastcall
#endif
#else
#define FASTCALL
#define CRYPTOCALL
#endif
