//
// Qt example: Table
//
// A simple, spreadsheet-like widget, made by inheriting  QTableView.
// 
// File: table.h
//
// Definition of the Table widget.
//

#ifndef TABLE_H
#define TABLE_H

#include <qtablevw.h>


class Table : public QTableView
{
    Q_OBJECT
public:
    Table( int numRows, int numCols, QWidget* parent=0, const char* name=0 );
    ~Table();
    
    const char* cellContent( int row, int col ) const;
    void setCellContent( int row, int col, const char* );

protected:
    void paintCell( QPainter*, int row, int col );
    void mousePressEvent( QMouseEvent* );
    void keyPressEvent( QKeyEvent* );
    void focusInEvent( QFocusEvent* );
    void focusOutEvent( QFocusEvent* );
    
private:
    int indexOf( int row, int col ) const;
    QString* contents;
    int curRow;
    int curCol;
};

#endif // TABLE_H
