#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Control.tcl,v $
# $Date: 1996/04/03 11:13:01 $
# $Revision: 1.16.1.30 $
#
#
#
proc busyFlag {} {global busy ; if $busy { } { } }
#
proc control_call {this op args} {
    upvar #0 $this cdata
    if [info exists cdata($op)] { return $cdata($op) }
    return [eval control_$op $this $args]
}
#
class Control {
    net		{}
    window	{}
    friends	{}
}
#
proc Control {cname args} {
    global zircon nicks ircnames Ops aways friendsStyle DEBUG \
      defChan signoffs monitorIn monitorOut OType ztrans
    set OType($cname) Control
    initObj $cname Control
    upvar #0 $cname cdata
    set ctl [set cdata(window) .$cname]
    proc $cname {args} "eval control_call $cname \$args"
    set net [set cdata(net) [lindex $args 1]] ;# hack alert.....
    toplevel $ctl -class Zircon -borderwidth 2
    set oFrm $ctl
    wm title $ctl {Zircon Control Panel}
    wm iconname $ctl {Zircon Control}
    wm resizable $ctl 0 0
    wm protocol $ctl WM_DELETE_WINDOW "$net quit"

    frame $oFrm.debug -borderwidth 0
    pack [frame $oFrm.debug.l0 -background $zircon(sepColor) -borderwidth 2] -fill x \
      -pady 4 -side bottom
    checkbutton $oFrm.debug.mo -text {Monitor Out} -variable monitorOut \
      -command zTrace
    checkbutton $oFrm.debug.mi -text {Monitor In} -variable monitorIn \
      -command zTrace
    button $oFrm.debug.dbg -text Debug -command zdebug
    pack $oFrm.debug.mo $oFrm.debug.mi $oFrm.debug.dbg -side left -expand 1
    if $DEBUG { pack $oFrm.debug -fill x }
    if {$monitorIn || $monitorOut} zTrace

    frame $oFrm.helpFrm -borderwidth 0
    set om [makeMB $oFrm.helpFrm.info "Zircon V$zircon(version)"]
    $om configure -tearoff 0
    $om add command -label "About Zircon" -command credits
    $om add cascade -label Configure -menu $om.conf
    menu $om.conf -tearoff 0
    foreach nn {IRC People Channels Windows Info} {
	$om.conf add command -label [trans $nn] -command "conf$nn $net"
    }
    $om.conf entryconfigure 3 -state disabled
    $om.conf add command -label {Save Current} -command saveCurrent
    $om.conf add command -label {Reread rc} -command reread -state disabled
    $om add cascade -label Register -menu $om.reg
    menu $om.reg -tearoff 0 -postcommand "register $net $om.reg"

    set om [makeMB $oFrm.helpFrm.help Help]
    foreach x [glob -nocomplain $zircon(lib)/help/*] {
	regexp {.*/([^/]*)} $x m x
	set nm [string tolower $x]
	$om add cascade -label $x -menu $om.$nm
	menu $om.$nm -tearoff 0 -postcommand "makeHelp $om.$nm $x"
    }
    $om add command -label "IRC Help Service" -command "getHelp $net"

    pack $oFrm.helpFrm.info $oFrm.helpFrm.help -side left -expand 1
    pack $oFrm.helpFrm -fill x

    pack [frame $oFrm.l1 -background $zircon(sepColor) -borderwidth 2] -fill x -pady 4

    set oc [frame $oFrm.cr -borderwidth 0]
    checkbutton $oc.busy -text $ztrans(busy) -command busyFlag -variable busy
    checkbutton $oc.invis -text Invisible -command "$net setFlag invisible" \
      -variable ${net}(invisible)
    checkbutton $oc.wallop -text Wallop -command "$net setFlag wallops" \
      -variable ${net}(wallops)
    checkbutton $oc.srvmsg -text SrvMsg -command "$net setFlag srvmsg" \
      -variable ${net}(srvmsg)
    checkbutton $oc.ircop -text {IRC Op} -command "$net deIRCOp" \
      -variable ${net}(ircop) -state disabled -foreground red
    pack $oc.busy $oc.invis $oc.wallop $oc.srvmsg $oc.ircop -side left
    pack $oc -fill x
    pack [frame $oFrm.l2 -background $zircon(sepColor) -borderwidth 2] -fill x -pady 4

    frame $oFrm.nSFrm -borderwidth 0
    NNSBuild $ctl Nickname nickname $nicks $net
    NNSBuild $ctl IRCName ircname $ircnames $net

    frame $oFrm.nSFrm.server -borderwidth 0
    set sm [makeMB $oFrm.nSFrm.server.label Server]
    set sl {}
    foreach nn [Server :: list] {
	set hst [$nn host]
	if {[set x [lsearch $sl "${hst}*"]] >= 0} { continue }
	lappend sl [list $hst $nn]
    }
    foreach nn [lsort $sl] {
	set lbl [lindex $sl 1]
	$sm add command -label [lindex $nn 0] \
	   -command "$net changeServer [lindex $nn 1]"
    }

    emacsEntry $oFrm.nSFrm.server.entry -relief sunken

    bind $oFrm.nSFrm.server.entry <Return> "
	$net changeServer \[Server :: make \[%W get\]\]
    "
    bind $oFrm.nSFrm.server.entry <Escape> "
	set h \[%W get\]
	mkEntryBox .@port {Port Number} \"Enter port number for \$h:\" \
	  {{$ztrans(port) 6667}} \
	  {$ztrans(ok) {$net changeServerPort \$h}} {$ztrans(cancel) {}}
    "

    pack $oFrm.nSFrm.server.label -side left
    pack $oFrm.nSFrm.server.entry -side left -expand 1 -fill x
    pack $oFrm.nSFrm.server -expand 1 -fill x
    if [string compare nil $zircon(host)] {
	    $oFrm.nSFrm.server.entry insert end [$zircon(host) host]
    }

    frame $oFrm.bf2 -borderwidth 0
    if [info exists Ops(server)] {
	set mn [makeMB $oFrm.bf2.servers Servers]
	foreach cmd $Ops(server) {
	    $mn add command -label [trans $cmd] -command "serverCmd $net $cmd"
	}
	if [info exists Ops(ircSrv)] {
	    foreach cmd $Ops(ircSrv) {
		$mn add command -label [trans $cmd] -foreground red \
		  -command "serverCmd $net $cmd"
	    }
	}

	if ![$net ircop] { setState $oFrm.bf2.servers.menu ircSrv disabled }
	pack $oFrm.bf2.servers -fill x -side left -expand 1
    }
    if [info exists Ops(user)] {
	set mn [makeMB $oFrm.bf2.users Users]
	foreach cmd $Ops(user) {
	    switch -exact -- $cmd {
	    DCC {
		   $mn add cascade -label $ztrans(dcc) -menu $mn.dcc
		    menu $mn.dcc -tearoff 0
		    foreach nn {List Send Chat Close} {
			$mn.dcc add command -label [trans $nn] -command "usersDCC $nn"
		    }
		}
	    CTCP { addCTCPMenu $net $mn {{}} }
	    default {
		    $mn add command -label [trans $cmd] -command "userCmd $net $cmd"
		}
	    }
	}
	if [info exists Ops(ircop)] {
	    foreach cmd $Ops(ircop) {
		$mn add command -label [trans $cmd] -foreground red \
		  -command "userCmd $net $cmd"
	    }
	}
	if ![$net ircop] { setState $oFrm.bf2.users.menu ircop disabled }
	pack $oFrm.bf2.users -side left -fill x -expand 1
    }
    set cm [makeMB $oFrm.bf2.channels Channels]
    $cm add command -label $ztrans(favourites) -command "faves $net"
    $cm add separator    
    foreach cmd "Join Who List Names Notice Monitor" {
	$cm add command -label [trans $cmd] \
	  -command "channel$cmd $net \[string trim \[$ctl.cmdLine.channel get\]\]"
    }
    addChanCTCPMenu $cm $cname
    $cm add separator
    foreach chan [Channel :: list] {
	if {$chan != $defChan && [$chan menu]} {
	    $cm add command -label [$chan name] -command "$chan sendJoin"
	}
    }
    makeMB $oFrm.bf2.services Services
    set i 3
    $oFrm.bf2.services.menu add command -label Exec -command "$net exec"
    $oFrm.bf2.services.menu add command -label Script \
      -command "doScript $net" -state disabled
    $oFrm.bf2.services.menu add separator
    foreach chn [Service :: list] {
	$oFrm.bf2.services.menu add cascade -label [$chn name] \
	  -menu $oFrm.bf2.services.menu.$i
	set m [menu $oFrm.bf2.services.menu.$i -tearoff 0]
	foreach nn [$chn ops] {
	    $m add command -label $nn -command "$chn do $nn"
	}
	incr i
    }

    pack [frame $oFrm.l3 -background $zircon(sepColor) -borderwidth 2] -fill x -pady 4

    frame $oFrm.bf1 -borderwidth 0
    makeMB $oFrm.bf1.away Away
    $oFrm.bf1.away.menu add command -label $ztrans(back) -command "$net AWAY"
    $oFrm.bf1.away.menu add command -label $ztrans(new) -command "$net getAway"
    $oFrm.bf1.away.menu add separator

    foreach act $aways {
	$oFrm.bf1.away.menu add command \
	  -label "[prune $act 15]" -command "$net AWAY {$act}"
    }

    button $oFrm.bf1.brb -command "$net doBRB" -width 10 -text $ztrans(brb)
    set cdata(friends) [Friends frnd$net -control $cname]
    if [friends_menu {}] {
	menubutton $oFrm.bf1.friends -width 10 -text Friends \
	    -menu $oFrm.bf1.friends.menu
	$cdata(friends) show
    } {
	button $oFrm.bf1.friends -width 10 -text Friends \
	  -command "$cdata(friends) show"
	global showFriends
	if $showFriends { $oFrm.bf1.friends invoke }
    }
    set qm [buttonmenu $oFrm.bf1.quit -command "$net quit" \
      -width 10 -text $ztrans(quit)]
    menu $qm.menu -tearoff 0
    $qm.menu add command -label $ztrans(new) -command "getQuit $ctl"
    $qm.menu add separator
    foreach x $signoffs {
	$qm.menu add command -label [prune $x 15] -command "$net doQuit {$x}"
    }

    pack $oFrm.bf1.away $oFrm.bf1.brb $oFrm.bf1.friends $oFrm.bf1.quit \
	-side left -fill x -expand 1
    pack $oFrm.bf2.channels $oFrm.bf2.services -side left -fill x -expand 1
    frame $oFrm.cmdLine -borderwidth 0 -relief flat
    label $oFrm.cmdLine.label -relief flat -text " $ztrans(channel) "
    emacsEntry $oFrm.cmdLine.channel -relief sunken
    pack $oFrm.cmdLine.label -side left
    pack $oFrm.cmdLine.channel -side left -expand 1 -fill x
    pack $oFrm.nSFrm $oFrm.bf1 $oFrm.bf2 -fill x
    pack [frame $oFrm.l4 -background $zircon(sepColor) -borderwidth 2] \
      -fill x -pady 4
    pack $oFrm.cmdLine -fill x

    bind $oFrm.cmdLine.channel <Return> "channelJoin $net \[%W get\] {}"

    tkwait visibility $ctl
    return $cname
}
#
# Build the Nickname and Ircname entries for the control window
#
proc NNSBuild {ctl lbl var lst net} {
    set frm $ctl.nSFrm
    set name [string tolower $lbl]
    pack $frm [frame $frm.$name -borderwidth 0] -fill x -pady 2
    set name $frm.$name

    set mn [makeMB $name.label $lbl]
    foreach nn [lsort $lst] {
	$mn add command -label $nn -command "$net change$lbl {$nn}"
    }
    emacsEntry $name.entry -relief sunken
    bind $name.entry <Return> "$net change$lbl \[%W get\]"

    pack $name.label -side left
    pack $name.entry -side left -expand 1 -fill x
    $name.entry insert end [lindex $lst 0]
    global $var ; set $var [lindex $lst 0]
}
#
proc register {net menu} {
    $menu delete 0 end
    $menu add command -label {Join mailing list} -command "doZList $net"
    $menu add command -label {Leave mailing list} -command "doZLeave $net"
    if [file exist ~/.zirconreg] {
	$menu add command -label {No update messages} \
	  -command "doDeregister $net"
    } {
	$menu add command -label {Get update messages} \
	  -command "doRegister $net"
    }
}
#
proc doRegister {net} {
    global zircon
    if ![file exists ~/.zirconreg] { 
	doBotcom $net REGISTER "$zircon(version) PL $zircon(patchlevel)"
	catch {close [open ~/.zirconreg w]}
    }
}
#
proc doDeregister {net} {
    if [file exists ~/.zirconreg] { 
	doBotcom $net DEREGISTER {}
	exec rm -f [glob ~/.zirconreg]
    }
}
#
proc doZList {net} {
    global ztrans
    mkEntryBox .@lj {Join mailing List} "Enter your email address:" \
      {{{Email address} {}}} "ztrans(ok) {doBotcom $net ZLIST}" \
      "ztrans(cancel) {}"
}
#
proc doZLeave {net} { doBotcom $net ZLEAVE {} }
#
proc doBotcom {net type par} { $net PRIVMSG ZirconBot "!$type $par" }
#
proc saveCurrent {} {
    foreach x [Channel :: list] { $x configure -keep 1 }
    foreach x [Message :: list] { $x configure -keep 1 }
    saverc
}
#
proc reread {} {
}
#
proc faves {net} {
    if [winfo exists [set w .@faves$net]] {popup $w ; return}
    global ztrans
    toplevel $w -class Zircon
    wm title $w Favourites
    wm resizable $w 0 1
    wm protocol $w WM_DELETE_WINDOW "killWindow $w"

    set win [frame $w.chans -relief raised]
    scrollbar $win.vscroller -command "$win.chList yview" 
    text $win.chList -yscrollcommand "bsSet $win.vscroller" -width 14 \
      -height 12
    bindtags $win.chList none
    pack $win.chList -side left -fill y
    button $win.ok -text $ztrans(dismiss) -command "killWindow $w"
    pack $win.ok -expand 1 -side right -fill y
    pack $w.chans -expand 1 -fill y
    foreach chan [Channel :: list] {
	if [$chan menu] {
	    set fm $win.chList.$chan
	    set cm [makeMB $fm [$chan name]]
	    $cm configure -postcommand "favecheck $cm $chan"
	    foreach cmd "Join Who Names Notice Monitor" {
		$cm add command -label $cmd \
		  -command "channel${cmd} $net [$chan name]"
	    }
	    addCTCPMenu $net $cm $chan
	    $win.chList window create end -window $fm
  	}
    }
}
#
proc favecheck {menu chan} {
    if [$chan active] {
	foreach e {4 6} { $menu entryconfigure $e -state normal }
	foreach e {1 3 5} { $menu entryconfigure $e -state disabled }
    } {
	foreach e {4 6} { $menu entryconfigure $e -state disabled }
	foreach e {1 3 5} { $menu entryconfigure $e -state normal }
    }
}
#
#
proc keepQuit {ctl v} {
    global signoffs confChange
    $ctl.bf1.quit add command -label "[prune $v 15]" \
      -command "[$ctl net] doQuit {$v}"
    lappend signoffs $v
    set confChange 1
}
#
proc getQuit {ctl} {
    global ztrans
    mkEntryBox .@q$ctl Quit "Enter your new signoff message:" \
      {{Signoff {}}} {Keep {keepQuit $ctl}} "ztrans(cancel) {}"
}
#
proc control_ircItems {this state} {
    foreach cid [Channel :: list] { $cid ircOp $state }
    set ctl [$this window]
    setState $ctl.bf2.servers.menu ircSrv $state
    setState $ctl.bf2.users.menu ircop $state
    $ctl.cr.ircop configure -state $state
}
