#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Log.tcl,v $
# $Date: 1996/03/11 14:06:09 $
# $Revision: 1.16.1.3 $
#
#
proc logOpen {this mode save file} {
    if [string match {} $file] {return 0}
    if ![string match {/*} $file] { set file "[pwd]/$file" }
    upvar #0 $this cdata
    if [catch {open $file $mode} cdata(log)] {
	[$this net] display ERROR \
	  "*** Cannot open log file for channel [$this name] : $cdata(log)"
	set cdata(log) {}
	return 0
    }
    set cdata(logfile) $file
    set w [$this window].channel.menu.log
    $w entryconfigure 0 -state normal
    $w entryconfigure 1 -state disabled
    $w entryconfigure 2 -state normal
    $w entryconfigure 3 -state normal
    puts $cdata(log) "**** Logging Started : [getDate]"
    if $save {
	puts $cdata(log) "**** Saving Window"
	puts $cdata(log) "[[$this text] get 1.0 end]"
	puts $cdata(log) "**** End of Window Text"
    }
    return 1
}

proc channel_doLog {this op} {
    upvar #0 $this cdata
    set w [$this window].channel.menu.log
    switch $op {
    Close {
	    if {$cdata(log) != {}} {
		close $cdata(log)
		set cdata(log) {}
	    }
	    $w entryconfigure 0 -state disabled
	    $w entryconfigure 1 -state normal
	    $w entryconfigure 2 -state disabled
	    $w entryconfigure 3 -state disabled
	}
    Empty {
	    if {$cdata(log) != {}} {
		close $cdata(log)
		set cdata(log) [open $cdata(logfile) w]
	    }
	}
    Flush {
	    if ![string match {} cdata(log)] {
		if [catch {flush $cdata(log)} msg] {
		   [$this net] display ERROR \
		     "*** Error flushing log file for channel [$this name] : $msg"
		   catch {close $cdata(log)}
		   set cdata(log) [open $cdata(logfile) a]
		}
	    }
	}
    Open {
	    set chan [$this name]
	    set fl [expr {[string match {} $cdata(logfile)] ? \
	      $cdata(logfile) : "$chan.log"}]
	    mkFileBox .@log$this "Log $chan" \
	      "Log file for channel $chan:" {} \
	      "Append {logOpen $this a 0 }"\
	      "{Append All} {logOpen $this a 1 }"\
	      "Open {logOpen $this w 0 }" \
	      "{Open from Start} {logOpen $this w 1 }" {Cancel {}}
	}
    }
}
