#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Server.tcl,v $
# $Date: 1996/03/11 11:07:13 $
# $Revision: 1.16.1.6 $
#
#
class Server {
    name	{}
    host	{}
    port	6667
    oper	{}
    operpw	{}
    script	{}
    sys		0
    passwd	{}
}
#
proc Server {name args} {
    if [string match {::} $name] {
	return [eval Server_[lindex $args 0] [lrange $args 1 end]]
    }
    set this [objName Server]
    initObj $this Server
    global $this STO
    set ${this}(name) $name
    set ${this}(host) $name
    set STO([string tolower $name]) $this
    proc $this {args} " eval server_call $this \$args "
    if ![string match {} $args] { eval $this configure $args }
    return $this
}
#
proc server_configure {this args} {
    upvar #0 $this sdata
    while {![string match {} $args]} {
	set sdata([string range [lindex $args 0] 1 end]) [lindex $args 1]
	set args [lrange $args 2 end]
    }
}
#
proc server_call {this op args} {
   upvar #0 $this sdata
   if [info exists sdata($op)] { return $sdata($op) }
   return [eval server_$op $this $args ]
}
#
proc server_delete {this} {
    uplevel #0 unset STO([string tolower [$this name]]) $this
    rename $this {}
}
#
proc Server_select {host} {
    global zircon
    if [string match {nil} [set zircon(host) [Server :: find $host]]] {
	mkInfoBox ERROR .@host {Server Host Error} \
	  "Cannot find host - $host" {OK {}}
    }
}
#
proc Server_list {} { return [info globals server*] }
#
proc Server_save {desc} {
    global STO
    foreach n [array names STO] {
	if [string match {default} $n] { continue }
	set ln "Server $n"
	set id $STO($n)
	if {[string tolower [$id host]] != $n} {
	    append ln " -host [$id host]"
	}
	if ![string match {6667} [$id port]] {
	    append ln " -port [$id port]"
	}
	if ![string match {} [$id oper]] { append ln " -oper [$id oper]" }
	if ![string match {} [$id operpw]] {
	    append ln " -operpw [$id operpw]"
	}
	if ![string match {} [$id script]] {
	    append ln " -script {[$id script]}"
	}
	puts $desc $ln
    }
}
#
proc Server_make {host} {
    if [string match {nil} [set s [Server :: find $host]]] {
	set s [Server $host]
    }
    return $s
}
#
proc server_pack {this where} {
    foreach v {host port oper operpw script name} {
	global ${where}S${v}
	set ${where}S${v}($this) [$this $v]
    }
    global newSTO
    set newSTO([string tolower [$this name]]) $this
}
#
proc server_unpack {this where} {
    foreach v {host port oper operpw script} {
	global $v ${where}S${v}
	$this configure -$v [set ${where}S${v}($this)]
	unset ${where}S${v}($this)
    }
    global ${where}Sname ${where}STO
    unset ${where}STO([string tolower [set ${where}Sname($this)]])
    unset ${where}Sname($this)
}
#
proc Server_pack {where} {
    foreach s [Server :: list] { if ![$s sys] { $s pack $where } }
}
#
proc Server_unpack {where} {
    global ${where}STO
    foreach s [array names ${where}STO] { [set ${where}STO($s)] unpack $where }
    Server :: cleanup $where
}
#
proc Server_cleanup {where} {
    foreach v {Shost Sport Soper Soperpw Sscript Sname STO} {
	global ${where}${v}
	catch {unset ${where}${v}}
    }
}
#
proc Server_find {name} {
    global STO
    set name [string tolower $name]
    if [info exists STO($name)] { return $STO($name) } { return nil }
}
