#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/User.tcl,v $
# $Date: 1996/04/03 13:53:22 $
# $Revision: 1.16.1.40 $
#
class User {
    name	{}
    lname	{}
    channels	{}
    notify	0
    friend	0
    ison	0
    limbo	0
    refcount	0
    crypt	{}
    id		{}
    net		net0
}
#
proc User {name args} {
    if ![string compare :: $name] {
	return [eval User_[lindex $args 0] [lrange $args 1 end]]
    }
    set this [objName User]
    initObj $this User
    global UTO
    upvar #0 $this udata
    set udata(name) $name
    set UTO([set udata(lname) [string tolower $name]]) $this
    proc $this {args} "eval user_call $this \$args"
    if ![string match {} $args] { eval $this configure $args }
    return $this
}
#
proc user_configure {this args} {
    upvar #0 $this udata
    while {![string match {} $args]} {
	set op [lindex $args 0]
	set val [lindex $args 1]
	switch -- $op {
	-friend {
		if [set udata(friend) $val] {
		    $this ref
		} {
		    $this deref
		}
	    }
	-notify {
		global notify
		set x [lsearch $notify [$this lname]]
		if [set udata(notify) $val] {
		    if {$x < 0} {
			lappend notify [$this lname]
			$this ref
		    }
		} \
	        elseif {$x >= 0} { listdel notify $x ; $this deref }
	    }
	default { set udata([string range $op 1 end]) $val }
	}
	set args [lrange $args 2 end]
    }
}
#
proc traceback {} {
    set x [info level]
    puts stderr {}
    while {$x > 0} { incr x -1 ; puts stderr [info level $x] }
}
#
proc user_call {this op args} {
    upvar #0 $this udata
    switch $op {
    isFriend { return $udata(friend) }
    isNotify { return $udata(notify) }
    ref { incr udata(refcount) ; return }
    deref { if {[incr udata(refcount) -1] <= 0} {$this delete} ; return }
    }
    if [info exists udata($op)] { return $udata($op) }
    return [eval user_$op $this $args]
}
#
proc user_delete {this} {
    global TFn TFa TFg TBg TAF TAB TBl Bl IFlag UTO OType $this
    $this configure -notify 0
    unset UTO([$this lname]) OType($this) $this
    foreach z {TFn TFa TFg TBg TAF TAB TBl Bl IFlag} {
	foreach v [array names $z $this,*] { unset ${z}($v) }
    }
    rename $this {}
}
#
proc user_substitute {this orig} {
    global TFn TFa TFg TBg TAF TAB TBl Bl IFlag UTO
    upvar #0 $this udata
    upvar #0 $orig odata
    array set udata [array get odata]
    set UTO([$this lname]) $this
    uplevel #0 unset OType($orig) $orig
    foreach z {TFn TFa TFg TBg TAF TAB TBl Bl IFlag} {
	foreach v [array names $z $orig,*] {
	    set x [lindex [split $v ,] 1]
	    set ${z}($this,$x) [set ${z}($v)]
	    unset ${z}($v)
	}
    }
    rename $orig {}
}
#
proc user_rename {this nk} {
    global UTO
    if [string compare nil [set orig [User :: find $nk]]] {
	if [string compare $this $orig] { $this substitute $orig }
    }
    upvar #0 $this udata
    if [set x [$this notify]] { $this configure -notify 0 }
    if [$this friend] {[[[$this net] control] friends] rename $this $nk }
    set udata(name) $nk
    unset UTO($udata(lname))
    set UTO([set udata(lname) [string tolower $nk]]) $this
    $this configure -notify $x
}
#
proc user_join {this chan} {
    upvar #0 $this udata
    if {[lsearch [set udata(channels)] $chan] < 0} {
	lappend udata(channels) $chan
    }
    $this ref
}
#
proc user_leave {this chan} {
    global TAB TAF TBg TFg TBl TFa TFn
    upvar #0 $chan cdata
    upvar #0 $this udata
    set ln [$this lname]
    catch {unset cdata(Op,$this) cdata(Spk,$this)}
    foreach x {TAB TAF TBg TFg TBl TFa TFn} { catch {unset ${x}($chan,$ln)} }
    if {[set x [lsearch $udata(channels) $chan]] >= 0} {
	listdel udata(channels) $x
	$this deref
    }
}
#
proc user_doNotify {this} {
    if [$this notify] {
	$this configure -notify 1
	[$this net] ISON
    } {
	if [$this ison] {
	    [[[$this net] control] friends] mark $this {}
	    $this configure -ison 0
	}
	$this configure -notify 0
    }
}
#
proc user_on {this} { $this configure -ison 1 -limbo 0 }
#
proc user_off {this} {
    $this configure -limbo 0 -ison 0
    [[[$this net] control] friends] remove $this
}
#
proc user_finger {this} { finger [$this net] [$this name] }
#
proc user_mode {this mode args} {
    [$this net] send MODE [$this name] $mode [lindex $args 0]
}
#
proc user_dcc {this cmd} {
    set nk [$this name]
    switch $cmd {
    SEND {
	    mkFileBox .@dccSend$nk "Send $nk" "File to send to $nk" {}\
	      "Send {DCCSend $this}" {Cancel {}}
	}
    CHAT {
	    global AChat
	    if [info exist AChat($this)] {
		mkDialog {} .@chat$this {Chat} \
		  "You already have a chat request pending for $nk." {} \
		  "Close {$this unChat}" {Keep {}}
	    } \
	    elseif {![string match nil [Chat :: find $nk]]} {
		mkDialog {} .@chat$this {Chat} \
		  "You already have a chat session open to $nk." {} \
		  {Keep {}} "Close {$this unChat}"
	    } \
	    elseif {[catch {ChatServer $this $nk} msg]}  {
		[$this net] display ERROR "*** [ipAddress] : $msg"
	    }
	}
    }
}
#
proc user_heal {this} {
    global Split Heal TSplit
    set told 0
    set net [$this net]
    foreach sl [array names Split] {
	if {[set x [lsearch $Split($sl) $this]] >= 0} {
	    catch {after cancel $TSplit($sl) ; unset TSplit($sl)}
	    if ![info exists Heal($sl)] {
		set told 1
		[$net info] optText HEAL "*** Heal - $sl"
		handleOn HEAL $sl
	    }
	    set v $Split($sl)
	    listdel v $x
	    $this deref
	    if ![string match {} $v] {
		set Split($sl) $v
		catch {after cancel $Heal($sl)}
		set Heal($sl) [after 120000 $net cleanSplit "{$sl}"]
	    } {
		unset Split($sl)
		catch { after cancel Heal($sl) ; unset Heal($sl) }
	    }
	}
    }
    if {[string compare nil [set id [Notice :: find [$this lname]]]] 
	&& [$id active]} {
	$id addText {} "*** Heal"
	$id flag normal
    }
    if {[string compare nil [set id [Message :: find [$this lname]]]]
	&& [$id active]} {
	$id addText {} "*** Heal"
	$id flag normal
    }
    [[$net control] friends] enable $this
}
#
proc user_unChat {this} {
    global AChat
    if [info exist AChat($this)] {
	global $AChat($this)
	catch {unset $AChat($this)}
	catch {shutdown $AChat($this) all}
	catch {close $AChat($this)}
	unset AChat($this)
    } \
    elseif {[set id [Chat :: find [$this name]]] != {nil}} { $id delete }
}
#
proc user_kill {this} { kill [$this net] [$this name] }
#
proc user_pack {this where} {
    foreach v {name lname notify friend id} {
	global ${where}U${v}
	set ${where}U${v}($this) [$this $v]
    }
    global UTO ${where}UTO
    set ln [$this lname]
    set ${where}UTO($ln) $UTO($ln)
}
#
proc user_unpack {this where} {
    foreach v {name notify friend id} {
	global ${where}U${v}
	$this configure -$v [set ${where}U${v}($this)]
	unset ${where}U${v}($this)
    }
    global ${where}UTO
    catch {unset ${where}UTO([$this lname])}
}
#
#
proc user_split {this split} {
    global Split
    set net [$this net]
    if ![info exists Split($split)] {
	[$net info] optText SPLIT "*** Netsplit - $split"
	global TSplit Heal
	set TSplit($split) [after 600000 $net cleanSplit "{$split}"]
	catch {after cancel $Heal($split) ; unset Heal($split)}
	handleOn SPLIT $split
    }
    foreach id [Channel :: list] {
	if [$id isJoined $this] {
	    set w [$id window]
	    if {[set x [indexHack $w.users.menu [$this name] 3]] >=0} {
		$w.users.menu entryconfigure $x -state disabled
	    }
	    $w.cFrm.uFrm.userBtn.$this conf -state disabled
	}
    }
    if {[string compare nil [set id [Notice :: find [$this lname]]]] &&
      [$id active]} {
	$id addText {} "*** Netsplit - $split"
	$id flag disabled
    }
    if {[string compare nil [set id [Message :: find [$this lname]]]] &&
      [$id active]} {
	$id addText {} "*** Netsplit - $split"
	$id flag disabled
    }
    [$net friends] disable $this
    $this configure -limbo 1
    lappend Split($split) $this
    $this ref
    handleOn USPLIT [list $split [$this lname]]
}
